package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait AnalyticsModality {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality
}
object AnalyticsModality {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality
  ): zio.aws.lexmodelsv2.model.AnalyticsModality = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.SPEECH =>
      val r = Speech
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.TEXT =>
      val r = Text
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.DTMF =>
      val r = DTMF
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.MULTI_MODE =>
      val r = MultiMode
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.AnalyticsModality {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.UNKNOWN_TO_SDK_VERSION
  }
  case object Speech extends zio.aws.lexmodelsv2.model.AnalyticsModality {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.SPEECH
  }
  case object Text extends zio.aws.lexmodelsv2.model.AnalyticsModality {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.TEXT
  }
  case object DTMF extends zio.aws.lexmodelsv2.model.AnalyticsModality {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.DTMF
  }
  case object MultiMode extends zio.aws.lexmodelsv2.model.AnalyticsModality {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality.MULTI_MODE
  }
}
