package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AnalyticsGroupByValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsIntentGroupByKey(
    name: Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentField] =
      Optional.Absent,
    value: Optional[AnalyticsGroupByValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupByKey = {
    import AnalyticsIntentGroupByKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupByKey
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          AnalyticsGroupByValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey.wrap(buildAwsValue())
}
object AnalyticsIntentGroupByKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupByKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey =
      zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentField]
    def value: Optional[AnalyticsGroupByValue]
    def getName
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsIntentField] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, AnalyticsGroupByValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupByKey
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey.ReadOnly {
    override val name
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentField] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentField.wrap(value)
        )
    override val value: Optional[AnalyticsGroupByValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsGroupByValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupByKey
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentGroupByKey.ReadOnly = new Wrapper(
    impl
  )
}
