package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  AnalyticsLongValue,
  BotAliasId,
  AnalyticsChannel,
  UtteranceUnderstood,
  Timestamp,
  NumericalBotVersion,
  AnalyticsSessionId,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class UtteranceSpecification(
    botAliasId: Optional[BotAliasId] = Optional.Absent,
    botVersion: Optional[NumericalBotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    sessionId: Optional[AnalyticsSessionId] = Optional.Absent,
    channel: Optional[AnalyticsChannel] = Optional.Absent,
    mode: Optional[zio.aws.lexmodelsv2.model.AnalyticsModality] =
      Optional.Absent,
    conversationStartTime: Optional[Timestamp] = Optional.Absent,
    conversationEndTime: Optional[Timestamp] = Optional.Absent,
    utterance: Optional[String] = Optional.Absent,
    utteranceTimestamp: Optional[Timestamp] = Optional.Absent,
    audioVoiceDurationMillis: Optional[AnalyticsLongValue] = Optional.Absent,
    utteranceUnderstood: Optional[UtteranceUnderstood] = Optional.Absent,
    inputType: Optional[String] = Optional.Absent,
    outputType: Optional[String] = Optional.Absent,
    associatedIntentName: Optional[Name] = Optional.Absent,
    associatedSlotName: Optional[Name] = Optional.Absent,
    intentState: Optional[zio.aws.lexmodelsv2.model.IntentState] =
      Optional.Absent,
    dialogActionType: Optional[String] = Optional.Absent,
    botResponseAudioVoiceId: Optional[String] = Optional.Absent,
    slotsFilledInSession: Optional[String] = Optional.Absent,
    utteranceRequestId: Optional[Id] = Optional.Absent,
    botResponses: Optional[
      Iterable[zio.aws.lexmodelsv2.model.UtteranceBotResponse]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification = {
    import UtteranceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        sessionId.map(value =>
          AnalyticsSessionId.unwrap(value): java.lang.String
        )
      )(_.sessionId)
      .optionallyWith(
        channel.map(value => AnalyticsChannel.unwrap(value): java.lang.String)
      )(_.channel)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        conversationStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.conversationStartTime)
      .optionallyWith(
        conversationEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.conversationEndTime)
      .optionallyWith(utterance.map(value => value: java.lang.String))(
        _.utterance
      )
      .optionallyWith(
        utteranceTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.utteranceTimestamp)
      .optionallyWith(
        audioVoiceDurationMillis.map(value =>
          AnalyticsLongValue.unwrap(value): java.lang.Long
        )
      )(_.audioVoiceDurationMillis)
      .optionallyWith(
        utteranceUnderstood.map(value =>
          UtteranceUnderstood.unwrap(value): java.lang.Boolean
        )
      )(_.utteranceUnderstood)
      .optionallyWith(inputType.map(value => value: java.lang.String))(
        _.inputType
      )
      .optionallyWith(outputType.map(value => value: java.lang.String))(
        _.outputType
      )
      .optionallyWith(
        associatedIntentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.associatedIntentName)
      .optionallyWith(
        associatedSlotName.map(value => Name.unwrap(value): java.lang.String)
      )(_.associatedSlotName)
      .optionallyWith(intentState.map(value => value.unwrap))(_.intentState)
      .optionallyWith(dialogActionType.map(value => value: java.lang.String))(
        _.dialogActionType
      )
      .optionallyWith(
        botResponseAudioVoiceId.map(value => value: java.lang.String)
      )(_.botResponseAudioVoiceId)
      .optionallyWith(
        slotsFilledInSession.map(value => value: java.lang.String)
      )(_.slotsFilledInSession)
      .optionallyWith(
        utteranceRequestId.map(value => Id.unwrap(value): java.lang.String)
      )(_.utteranceRequestId)
      .optionallyWith(
        botResponses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botResponses)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UtteranceSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.UtteranceSpecification.wrap(buildAwsValue())
}
object UtteranceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UtteranceSpecification =
      zio.aws.lexmodelsv2.model.UtteranceSpecification(
        botAliasId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        sessionId.map(value => value),
        channel.map(value => value),
        mode.map(value => value),
        conversationStartTime.map(value => value),
        conversationEndTime.map(value => value),
        utterance.map(value => value),
        utteranceTimestamp.map(value => value),
        audioVoiceDurationMillis.map(value => value),
        utteranceUnderstood.map(value => value),
        inputType.map(value => value),
        outputType.map(value => value),
        associatedIntentName.map(value => value),
        associatedSlotName.map(value => value),
        intentState.map(value => value),
        dialogActionType.map(value => value),
        botResponseAudioVoiceId.map(value => value),
        slotsFilledInSession.map(value => value),
        utteranceRequestId.map(value => value),
        botResponses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botAliasId: Optional[BotAliasId]
    def botVersion: Optional[NumericalBotVersion]
    def localeId: Optional[LocaleId]
    def sessionId: Optional[AnalyticsSessionId]
    def channel: Optional[AnalyticsChannel]
    def mode: Optional[zio.aws.lexmodelsv2.model.AnalyticsModality]
    def conversationStartTime: Optional[Timestamp]
    def conversationEndTime: Optional[Timestamp]
    def utterance: Optional[String]
    def utteranceTimestamp: Optional[Timestamp]
    def audioVoiceDurationMillis: Optional[AnalyticsLongValue]
    def utteranceUnderstood: Optional[UtteranceUnderstood]
    def inputType: Optional[String]
    def outputType: Optional[String]
    def associatedIntentName: Optional[Name]
    def associatedSlotName: Optional[Name]
    def intentState: Optional[zio.aws.lexmodelsv2.model.IntentState]
    def dialogActionType: Optional[String]
    def botResponseAudioVoiceId: Optional[String]
    def slotsFilledInSession: Optional[String]
    def utteranceRequestId: Optional[Id]
    def botResponses: Optional[
      List[zio.aws.lexmodelsv2.model.UtteranceBotResponse.ReadOnly]
    ]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getSessionId: ZIO[Any, AwsError, AnalyticsSessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getChannel: ZIO[Any, AwsError, AnalyticsChannel] =
      AwsError.unwrapOptionField("channel", channel)
    def getMode
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsModality] =
      AwsError.unwrapOptionField("mode", mode)
    def getConversationStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("conversationStartTime", conversationStartTime)
    def getConversationEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("conversationEndTime", conversationEndTime)
    def getUtterance: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("utterance", utterance)
    def getUtteranceTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("utteranceTimestamp", utteranceTimestamp)
    def getAudioVoiceDurationMillis: ZIO[Any, AwsError, AnalyticsLongValue] =
      AwsError.unwrapOptionField(
        "audioVoiceDurationMillis",
        audioVoiceDurationMillis
      )
    def getUtteranceUnderstood: ZIO[Any, AwsError, UtteranceUnderstood] =
      AwsError.unwrapOptionField("utteranceUnderstood", utteranceUnderstood)
    def getInputType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("inputType", inputType)
    def getOutputType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outputType", outputType)
    def getAssociatedIntentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("associatedIntentName", associatedIntentName)
    def getAssociatedSlotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("associatedSlotName", associatedSlotName)
    def getIntentState
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.IntentState] =
      AwsError.unwrapOptionField("intentState", intentState)
    def getDialogActionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dialogActionType", dialogActionType)
    def getBotResponseAudioVoiceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("botResponseAudioVoiceId", botResponseAudioVoiceId)
    def getSlotsFilledInSession: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotsFilledInSession", slotsFilledInSession)
    def getUtteranceRequestId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("utteranceRequestId", utteranceRequestId)
    def getBotResponses: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.UtteranceBotResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("botResponses", botResponses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification
  ) extends zio.aws.lexmodelsv2.model.UtteranceSpecification.ReadOnly {
    override val botAliasId: Optional[BotAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botVersion: Optional[NumericalBotVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botVersion())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
        )
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val sessionId: Optional[AnalyticsSessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsSessionId(value)
      )
    override val channel: Optional[AnalyticsChannel] = zio.aws.core.internal
      .optionalFromNullable(impl.channel())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsChannel(value)
      )
    override val mode: Optional[zio.aws.lexmodelsv2.model.AnalyticsModality] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsModality.wrap(value))
    override val conversationStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationStartTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val conversationEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationEndTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val utterance: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.utterance())
      .map(value => value: String)
    override val utteranceTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.utteranceTimestamp())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val audioVoiceDurationMillis: Optional[AnalyticsLongValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audioVoiceDurationMillis())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.AnalyticsLongValue(value)
        )
    override val utteranceUnderstood: Optional[UtteranceUnderstood] =
      zio.aws.core.internal
        .optionalFromNullable(impl.utteranceUnderstood())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.UtteranceUnderstood(value)
        )
    override val inputType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.inputType())
      .map(value => value: String)
    override val outputType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outputType())
      .map(value => value: String)
    override val associatedIntentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.associatedIntentName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val associatedSlotName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.associatedSlotName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val intentState: Optional[zio.aws.lexmodelsv2.model.IntentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intentState())
        .map(value => zio.aws.lexmodelsv2.model.IntentState.wrap(value))
    override val dialogActionType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dialogActionType())
      .map(value => value: String)
    override val botResponseAudioVoiceId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botResponseAudioVoiceId())
        .map(value => value: String)
    override val slotsFilledInSession: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slotsFilledInSession())
      .map(value => value: String)
    override val utteranceRequestId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.utteranceRequestId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botResponses: Optional[
      List[zio.aws.lexmodelsv2.model.UtteranceBotResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botResponses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.UtteranceBotResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification
  ): zio.aws.lexmodelsv2.model.UtteranceSpecification.ReadOnly = new Wrapper(
    impl
  )
}
