package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TextLogDestination(
    cloudWatch: zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TextLogDestination = {
    import TextLogDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TextLogDestination
      .builder()
      .cloudWatch(cloudWatch.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TextLogDestination.ReadOnly =
    zio.aws.lexmodelsv2.model.TextLogDestination.wrap(buildAwsValue())
}
object TextLogDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TextLogDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TextLogDestination =
      zio.aws.lexmodelsv2.model.TextLogDestination(cloudWatch.asEditable)
    def cloudWatch
        : zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination.ReadOnly
    def getCloudWatch: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination.ReadOnly
    ] = ZIO.succeed(cloudWatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TextLogDestination
  ) extends zio.aws.lexmodelsv2.model.TextLogDestination.ReadOnly {
    override val cloudWatch
        : zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination.ReadOnly =
      zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination
        .wrap(impl.cloudWatch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TextLogDestination
  ): zio.aws.lexmodelsv2.model.TextLogDestination.ReadOnly = new Wrapper(impl)
}
