package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTestSetsRequest(
    sortBy: Optional[zio.aws.lexmodelsv2.model.TestSetSortBy] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest = {
    import ListTestSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListTestSetsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListTestSetsRequest.wrap(buildAwsValue())
}
object ListTestSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListTestSetsRequest =
      zio.aws.lexmodelsv2.model.ListTestSetsRequest(
        sortBy.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sortBy: Optional[zio.aws.lexmodelsv2.model.TestSetSortBy.ReadOnly]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestSetSortBy.ReadOnly] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest
  ) extends zio.aws.lexmodelsv2.model.ListTestSetsRequest.ReadOnly {
    override val sortBy
        : Optional[zio.aws.lexmodelsv2.model.TestSetSortBy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.lexmodelsv2.model.TestSetSortBy.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest
  ): zio.aws.lexmodelsv2.model.ListTestSetsRequest.ReadOnly = new Wrapper(impl)
}
