package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsIntentStageMetric(
    name: zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName,
    statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic,
    order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetric = {
    import AnalyticsIntentStageMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetric
      .builder()
      .name(name.unwrap)
      .statistic(statistic.unwrap)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetric.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetric.wrap(buildAwsValue())
}
object AnalyticsIntentStageMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetric =
      zio.aws.lexmodelsv2.model
        .AnalyticsIntentStageMetric(name, statistic, order.map(value => value))
    def name: zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName
    def statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    def order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName
    ] = ZIO.succeed(name)
    def getStatistic: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    ] = ZIO.succeed(statistic)
    def getOrder
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetric
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetric.ReadOnly {
    override val name
        : zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName =
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName.wrap(impl.name())
    override val statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic =
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic.wrap(impl.statistic())
    override val order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetric
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetric.ReadOnly =
    new Wrapper(impl)
}
