package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.TestSetUtteranceText
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UserTurnOutputSpecification(
    intent: zio.aws.lexmodelsv2.model.UserTurnIntentOutput,
    activeContexts: Optional[
      Iterable[zio.aws.lexmodelsv2.model.ActiveContext]
    ] = Optional.Absent,
    transcript: Optional[TestSetUtteranceText] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UserTurnOutputSpecification = {
    import UserTurnOutputSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnOutputSpecification
      .builder()
      .intent(intent.buildAwsValue())
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .optionallyWith(
        transcript.map(value =>
          TestSetUtteranceText.unwrap(value): java.lang.String
        )
      )(_.transcript)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.wrap(buildAwsValue())
}
object UserTurnOutputSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnOutputSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UserTurnOutputSpecification =
      zio.aws.lexmodelsv2.model.UserTurnOutputSpecification(
        intent.asEditable,
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        transcript.map(value => value)
      )
    def intent: zio.aws.lexmodelsv2.model.UserTurnIntentOutput.ReadOnly
    def activeContexts
        : Optional[List[zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly]]
    def transcript: Optional[TestSetUtteranceText]
    def getIntent: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.UserTurnIntentOutput.ReadOnly
    ] = ZIO.succeed(intent)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
    def getTranscript: ZIO[Any, AwsError, TestSetUtteranceText] =
      AwsError.unwrapOptionField("transcript", transcript)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnOutputSpecification
  ) extends zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly {
    override val intent
        : zio.aws.lexmodelsv2.model.UserTurnIntentOutput.ReadOnly =
      zio.aws.lexmodelsv2.model.UserTurnIntentOutput.wrap(impl.intent())
    override val activeContexts
        : Optional[List[zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.ActiveContext.wrap(item)
          }.toList
        )
    override val transcript: Optional[TestSetUtteranceText] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcript())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.TestSetUtteranceText(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnOutputSpecification
  ): zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly =
    new Wrapper(impl)
}
