package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  KmsKeyArn,
  S3ObjectPath,
  S3BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TestSetStorageLocation(
    s3BucketName: S3BucketName,
    s3Path: S3ObjectPath,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation = {
    import TestSetStorageLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation
      .builder()
      .s3BucketName(S3BucketName.unwrap(s3BucketName): java.lang.String)
      .s3Path(S3ObjectPath.unwrap(s3Path): java.lang.String)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetStorageLocation.wrap(buildAwsValue())
}
object TestSetStorageLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetStorageLocation =
      zio.aws.lexmodelsv2.model.TestSetStorageLocation(
        s3BucketName,
        s3Path,
        kmsKeyArn.map(value => value)
      )
    def s3BucketName: S3BucketName
    def s3Path: S3ObjectPath
    def kmsKeyArn: Optional[KmsKeyArn]
    def getS3BucketName: ZIO[Any, Nothing, S3BucketName] =
      ZIO.succeed(s3BucketName)
    def getS3Path: ZIO[Any, Nothing, S3ObjectPath] = ZIO.succeed(s3Path)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation
  ) extends zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly {
    override val s3BucketName: S3BucketName =
      zio.aws.lexmodelsv2.model.primitives.S3BucketName(impl.s3BucketName())
    override val s3Path: S3ObjectPath =
      zio.aws.lexmodelsv2.model.primitives.S3ObjectPath(impl.s3Path())
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation
  ): zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly = new Wrapper(
    impl
  )
}
