package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, BotAliasId, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestSetDiscrepancyReportBotAliasTarget(
    botId: Id,
    botAliasId: BotAliasId,
    localeId: LocaleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget = {
    import TestSetDiscrepancyReportBotAliasTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botAliasId(BotAliasId.unwrap(botAliasId): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget
      .wrap(buildAwsValue())
}
object TestSetDiscrepancyReportBotAliasTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget =
      zio.aws.lexmodelsv2.model
        .TestSetDiscrepancyReportBotAliasTarget(botId, botAliasId, localeId)
    def botId: Id
    def botAliasId: BotAliasId
    def localeId: LocaleId
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, Nothing, BotAliasId] = ZIO.succeed(botAliasId)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget
  ) extends zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botAliasId: BotAliasId =
      zio.aws.lexmodelsv2.model.primitives.BotAliasId(impl.botAliasId())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget
  ): zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget.ReadOnly =
    new Wrapper(impl)
}
