package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IntentFilter(
    name: zio.aws.lexmodelsv2.model.IntentFilterName,
    values: Iterable[FilterValue],
    operator: zio.aws.lexmodelsv2.model.IntentFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentFilter = {
    import IntentFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentFilter.wrap(buildAwsValue())
}
object IntentFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentFilter =
      zio.aws.lexmodelsv2.model.IntentFilter(name, values, operator)
    def name: zio.aws.lexmodelsv2.model.IntentFilterName
    def values: List[FilterValue]
    def operator: zio.aws.lexmodelsv2.model.IntentFilterOperator
    def getName: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.IntentFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.IntentFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentFilter
  ) extends zio.aws.lexmodelsv2.model.IntentFilter.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.IntentFilterName =
      zio.aws.lexmodelsv2.model.IntentFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
    override val operator: zio.aws.lexmodelsv2.model.IntentFilterOperator =
      zio.aws.lexmodelsv2.model.IntentFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentFilter
  ): zio.aws.lexmodelsv2.model.IntentFilter.ReadOnly = new Wrapper(impl)
}
