package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsSessionResult(
    binKeys: Optional[Iterable[zio.aws.lexmodelsv2.model.AnalyticsBinKey]] =
      Optional.Absent,
    groupByKeys: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey]
    ] = Optional.Absent,
    metricsResults: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsSessionMetricResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionResult = {
    import AnalyticsSessionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionResult
      .builder()
      .optionallyWith(
        binKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.binKeys)
      .optionallyWith(
        groupByKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupByKeys)
      .optionallyWith(
        metricsResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricsResults)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AnalyticsSessionResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsSessionResult.wrap(buildAwsValue())
}
object AnalyticsSessionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsSessionResult =
      zio.aws.lexmodelsv2.model.AnalyticsSessionResult(
        binKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupByKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricsResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def binKeys
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly]]
    def groupByKeys: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey.ReadOnly]
    ]
    def metricsResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsSessionMetricResult.ReadOnly]
    ]
    def getBinKeys: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly
    ]] = AwsError.unwrapOptionField("binKeys", binKeys)
    def getGroupByKeys: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey.ReadOnly
    ]] = AwsError.unwrapOptionField("groupByKeys", groupByKeys)
    def getMetricsResults: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsSessionMetricResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricsResults", metricsResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionResult
  ) extends zio.aws.lexmodelsv2.model.AnalyticsSessionResult.ReadOnly {
    override val binKeys
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.binKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.AnalyticsBinKey.wrap(item)
          }.toList
        )
    override val groupByKeys: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupByKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey.wrap(item)
        }.toList
      )
    override val metricsResults: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsSessionMetricResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricsResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsSessionMetricResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionResult
  ): zio.aws.lexmodelsv2.model.AnalyticsSessionResult.ReadOnly = new Wrapper(
    impl
  )
}
