package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AnalyticsMetricValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsIntentMetricResult(
    name: Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName] =
      Optional.Absent,
    statistic: Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic] =
      Optional.Absent,
    value: Optional[AnalyticsMetricValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetricResult = {
    import AnalyticsIntentMetricResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetricResult
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => AnalyticsMetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult.wrap(buildAwsValue())
}
object AnalyticsIntentMetricResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetricResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult =
      zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName]
    def statistic: Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic]
    def value: Optional[AnalyticsMetricValue]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatistic: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, AnalyticsMetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetricResult
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult.ReadOnly {
    override val name
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName.wrap(value)
        )
    override val statistic
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic.wrap(value)
        )
    override val value: Optional[AnalyticsMetricValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsMetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetricResult
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentMetricResult.ReadOnly =
    new Wrapper(impl)
}
