package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  MaxResults,
  Timestamp,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListIntentMetricsRequest(
    botId: Id,
    startDateTime: Timestamp,
    endDateTime: Timestamp,
    metrics: Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentMetric],
    binBy: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification]
    ] = Optional.Absent,
    groupBy: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentGroupBySpecification]
    ] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest = {
    import ListIntentMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .startDateTime(Timestamp.unwrap(startDateTime): Instant)
      .endDateTime(Timestamp.unwrap(endDateTime): Instant)
      .metrics(metrics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        binBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.binBy)
      .optionallyWith(
        groupBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListIntentMetricsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListIntentMetricsRequest.wrap(buildAwsValue())
}
object ListIntentMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListIntentMetricsRequest =
      zio.aws.lexmodelsv2.model.ListIntentMetricsRequest(
        botId,
        startDateTime,
        endDateTime,
        metrics.map { item =>
          item.asEditable
        },
        binBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def startDateTime: Timestamp
    def endDateTime: Timestamp
    def metrics: List[zio.aws.lexmodelsv2.model.AnalyticsIntentMetric.ReadOnly]
    def binBy: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly]
    ]
    def groupBy: Optional[List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentGroupBySpecification.ReadOnly
    ]]
    def filters: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentFilter.ReadOnly]
    ]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getStartDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startDateTime)
    def getEndDateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDateTime)
    def getMetrics: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentMetric.ReadOnly
    ]] = ZIO.succeed(metrics)
    def getBinBy: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("binBy", binBy)
    def getGroupBy: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentGroupBySpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("groupBy", groupBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest
  ) extends zio.aws.lexmodelsv2.model.ListIntentMetricsRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val startDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.startDateTime())
    override val endDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.endDateTime())
    override val metrics
        : List[zio.aws.lexmodelsv2.model.AnalyticsIntentMetric.ReadOnly] = impl
      .metrics()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.AnalyticsIntentMetric.wrap(item)
      }
      .toList
    override val binBy: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.binBy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.wrap(item)
        }.toList
      )
    override val groupBy: Optional[List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentGroupBySpecification.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.groupBy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentGroupBySpecification
            .wrap(item)
        }.toList
      )
    override val filters: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest
  ): zio.aws.lexmodelsv2.model.ListIntentMetricsRequest.ReadOnly = new Wrapper(
    impl
  )
}
