package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IntentClassificationTestResults(
    items: Iterable[
      zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResults = {
    import IntentClassificationTestResults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResults
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.IntentClassificationTestResults.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentClassificationTestResults
      .wrap(buildAwsValue())
}
object IntentClassificationTestResults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentClassificationTestResults =
      zio.aws.lexmodelsv2.model.IntentClassificationTestResults(items.map {
        item =>
          item.asEditable
      })
    def items: List[
      zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem.ReadOnly
    ]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem.ReadOnly
    ]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResults
  ) extends zio.aws.lexmodelsv2.model.IntentClassificationTestResults.ReadOnly {
    override val items: List[
      zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem.ReadOnly
    ] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResults
  ): zio.aws.lexmodelsv2.model.IntentClassificationTestResults.ReadOnly =
    new Wrapper(impl)
}
