package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  BotAliasId,
  Timestamp,
  TagValue,
  NumericalBotVersion,
  Description,
  Name,
  Id,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateBotAliasResponse(
    botAliasId: Optional[BotAliasId] = Optional.Absent,
    botAliasName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    botVersion: Optional[NumericalBotVersion] = Optional.Absent,
    botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings]
    ] = Optional.Absent,
    conversationLogSettings: Optional[
      zio.aws.lexmodelsv2.model.ConversationLogSettings
    ] = Optional.Absent,
    sentimentAnalysisSettings: Optional[
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings
    ] = Optional.Absent,
    botAliasStatus: Optional[zio.aws.lexmodelsv2.model.BotAliasStatus] =
      Optional.Absent,
    botId: Optional[Id] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse = {
    import CreateBotAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botAliasName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botAliasName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        botVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.botVersion)
      .optionallyWith(
        botAliasLocaleSettings.map(value =>
          value
            .map({ case (key, value) =>
              (LocaleId.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.botAliasLocaleSettings)
      .optionallyWith(
        conversationLogSettings.map(value => value.buildAwsValue())
      )(_.conversationLogSettings)
      .optionallyWith(
        sentimentAnalysisSettings.map(value => value.buildAwsValue())
      )(_.sentimentAnalysisSettings)
      .optionallyWith(botAliasStatus.map(value => value.unwrap))(
        _.botAliasStatus
      )
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateBotAliasResponse.wrap(buildAwsValue())
}
object CreateBotAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateBotAliasResponse =
      zio.aws.lexmodelsv2.model.CreateBotAliasResponse(
        botAliasId.map(value => value),
        botAliasName.map(value => value),
        description.map(value => value),
        botVersion.map(value => value),
        botAliasLocaleSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conversationLogSettings.map(value => value.asEditable),
        sentimentAnalysisSettings.map(value => value.asEditable),
        botAliasStatus.map(value => value),
        botId.map(value => value),
        creationDateTime.map(value => value),
        tags.map(value => value)
      )
    def botAliasId: Optional[BotAliasId]
    def botAliasName: Optional[Name]
    def description: Optional[Description]
    def botVersion: Optional[NumericalBotVersion]
    def botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ]
    def conversationLogSettings
        : Optional[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly]
    def sentimentAnalysisSettings
        : Optional[zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly]
    def botAliasStatus: Optional[zio.aws.lexmodelsv2.model.BotAliasStatus]
    def botId: Optional[Id]
    def creationDateTime: Optional[Timestamp]
    def tags: Optional[Map[TagKey, TagValue]]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotAliasName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botAliasName", botAliasName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotAliasLocaleSettings: ZIO[Any, AwsError, Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "botAliasLocaleSettings",
      botAliasLocaleSettings
    )
    def getConversationLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLogSettings",
      conversationLogSettings
    )
    def getSentimentAnalysisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sentimentAnalysisSettings",
      sentimentAnalysisSettings
    )
    def getBotAliasStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotAliasStatus] =
      AwsError.unwrapOptionField("botAliasStatus", botAliasStatus)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse
  ) extends zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly {
    override val botAliasId: Optional[BotAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botAliasName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botVersion: Optional[NumericalBotVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botVersion())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
        )
    override val botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasLocaleSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.LocaleId(
              key
            ) -> zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.wrap(value)
          })
          .toMap
      )
    override val conversationLogSettings
        : Optional[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationLogSettings())
        .map(value =>
          zio.aws.lexmodelsv2.model.ConversationLogSettings.wrap(value)
        )
    override val sentimentAnalysisSettings: Optional[
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sentimentAnalysisSettings())
      .map(value =>
        zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.wrap(value)
      )
    override val botAliasStatus
        : Optional[zio.aws.lexmodelsv2.model.BotAliasStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botAliasStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotAliasStatus.wrap(value))
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.TagKey(
              key
            ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse
  ): zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
