package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UtteranceBotResponse(
    content: Optional[String] = Optional.Absent,
    contentType: Optional[zio.aws.lexmodelsv2.model.UtteranceContentType] =
      Optional.Absent,
    imageResponseCard: Optional[zio.aws.lexmodelsv2.model.ImageResponseCard] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceBotResponse = {
    import UtteranceBotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceBotResponse
      .builder()
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(contentType.map(value => value.unwrap))(_.contentType)
      .optionallyWith(imageResponseCard.map(value => value.buildAwsValue()))(
        _.imageResponseCard
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UtteranceBotResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UtteranceBotResponse.wrap(buildAwsValue())
}
object UtteranceBotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceBotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UtteranceBotResponse =
      zio.aws.lexmodelsv2.model.UtteranceBotResponse(
        content.map(value => value),
        contentType.map(value => value),
        imageResponseCard.map(value => value.asEditable)
      )
    def content: Optional[String]
    def contentType: Optional[zio.aws.lexmodelsv2.model.UtteranceContentType]
    def imageResponseCard
        : Optional[zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly]
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getContentType
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.UtteranceContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getImageResponseCard: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly
    ] = AwsError.unwrapOptionField("imageResponseCard", imageResponseCard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceBotResponse
  ) extends zio.aws.lexmodelsv2.model.UtteranceBotResponse.ReadOnly {
    override val content: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: String)
    override val contentType
        : Optional[zio.aws.lexmodelsv2.model.UtteranceContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value =>
          zio.aws.lexmodelsv2.model.UtteranceContentType.wrap(value)
        )
    override val imageResponseCard
        : Optional[zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageResponseCard())
        .map(value => zio.aws.lexmodelsv2.model.ImageResponseCard.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceBotResponse
  ): zio.aws.lexmodelsv2.model.UtteranceBotResponse.ReadOnly = new Wrapper(impl)
}
