package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TestExecutionResultFilterBy(
    resultTypeFilter: zio.aws.lexmodelsv2.model.TestResultTypeFilter,
    conversationLevelTestResultsFilterBy: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelTestResultsFilterBy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultFilterBy = {
    import TestExecutionResultFilterBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultFilterBy
      .builder()
      .resultTypeFilter(resultTypeFilter.unwrap)
      .optionallyWith(
        conversationLevelTestResultsFilterBy.map(value => value.buildAwsValue())
      )(_.conversationLevelTestResultsFilterBy)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy.ReadOnly =
    zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy.wrap(buildAwsValue())
}
object TestExecutionResultFilterBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultFilterBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy =
      zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy(
        resultTypeFilter,
        conversationLevelTestResultsFilterBy.map(value => value.asEditable)
      )
    def resultTypeFilter: zio.aws.lexmodelsv2.model.TestResultTypeFilter
    def conversationLevelTestResultsFilterBy: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelTestResultsFilterBy.ReadOnly
    ]
    def getResultTypeFilter
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TestResultTypeFilter] =
      ZIO.succeed(resultTypeFilter)
    def getConversationLevelTestResultsFilterBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLevelTestResultsFilterBy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLevelTestResultsFilterBy",
      conversationLevelTestResultsFilterBy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultFilterBy
  ) extends zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy.ReadOnly {
    override val resultTypeFilter
        : zio.aws.lexmodelsv2.model.TestResultTypeFilter =
      zio.aws.lexmodelsv2.model.TestResultTypeFilter
        .wrap(impl.resultTypeFilter())
    override val conversationLevelTestResultsFilterBy: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelTestResultsFilterBy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conversationLevelTestResultsFilterBy())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConversationLevelTestResultsFilterBy
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultFilterBy
  ): zio.aws.lexmodelsv2.model.TestExecutionResultFilterBy.ReadOnly =
    new Wrapper(impl)
}
