package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NextToken, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSessionAnalyticsDataResponse(
    botId: Optional[Id] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sessions: Optional[
      Iterable[zio.aws.lexmodelsv2.model.SessionSpecification]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse = {
    import ListSessionAnalyticsDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        sessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sessions)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListSessionAnalyticsDataResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListSessionAnalyticsDataResponse
      .wrap(buildAwsValue())
}
object ListSessionAnalyticsDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListSessionAnalyticsDataResponse =
      zio.aws.lexmodelsv2.model.ListSessionAnalyticsDataResponse(
        botId.map(value => value),
        nextToken.map(value => value),
        sessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botId: Optional[Id]
    def nextToken: Optional[NextToken]
    def sessions: Optional[
      List[zio.aws.lexmodelsv2.model.SessionSpecification.ReadOnly]
    ]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSessions: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SessionSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("sessions", sessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse
  ) extends zio.aws.lexmodelsv2.model.ListSessionAnalyticsDataResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val sessions: Optional[
      List[zio.aws.lexmodelsv2.model.SessionSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sessions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.SessionSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse
  ): zio.aws.lexmodelsv2.model.ListSessionAnalyticsDataResponse.ReadOnly =
    new Wrapper(impl)
}
