package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, BotAliasId, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConversationLogsDataSource(
    botId: Id,
    botAliasId: BotAliasId,
    localeId: LocaleId,
    filter: zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSource = {
    import ConversationLogsDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSource
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botAliasId(BotAliasId.unwrap(botAliasId): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .filter(filter.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ConversationLogsDataSource.ReadOnly =
    zio.aws.lexmodelsv2.model.ConversationLogsDataSource.wrap(buildAwsValue())
}
object ConversationLogsDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ConversationLogsDataSource =
      zio.aws.lexmodelsv2.model.ConversationLogsDataSource(
        botId,
        botAliasId,
        localeId,
        filter.asEditable
      )
    def botId: Id
    def botAliasId: BotAliasId
    def localeId: LocaleId
    def filter
        : zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy.ReadOnly
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, Nothing, BotAliasId] = ZIO.succeed(botAliasId)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getFilter: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy.ReadOnly
    ] = ZIO.succeed(filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSource
  ) extends zio.aws.lexmodelsv2.model.ConversationLogsDataSource.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botAliasId: BotAliasId =
      zio.aws.lexmodelsv2.model.primitives.BotAliasId(impl.botAliasId())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val filter
        : zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy.ReadOnly =
      zio.aws.lexmodelsv2.model.ConversationLogsDataSourceFilterBy
        .wrap(impl.filter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLogsDataSource
  ): zio.aws.lexmodelsv2.model.ConversationLogsDataSource.ReadOnly =
    new Wrapper(impl)
}
