package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.TestSetUtteranceText
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UtteranceInputSpecification(
    textInput: Optional[TestSetUtteranceText] = Optional.Absent,
    audioInput: Optional[
      zio.aws.lexmodelsv2.model.UtteranceAudioInputSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UtteranceInputSpecification = {
    import UtteranceInputSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceInputSpecification
      .builder()
      .optionallyWith(
        textInput.map(value =>
          TestSetUtteranceText.unwrap(value): java.lang.String
        )
      )(_.textInput)
      .optionallyWith(audioInput.map(value => value.buildAwsValue()))(
        _.audioInput
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UtteranceInputSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.UtteranceInputSpecification.wrap(buildAwsValue())
}
object UtteranceInputSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UtteranceInputSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UtteranceInputSpecification =
      zio.aws.lexmodelsv2.model.UtteranceInputSpecification(
        textInput.map(value => value),
        audioInput.map(value => value.asEditable)
      )
    def textInput: Optional[TestSetUtteranceText]
    def audioInput: Optional[
      zio.aws.lexmodelsv2.model.UtteranceAudioInputSpecification.ReadOnly
    ]
    def getTextInput: ZIO[Any, AwsError, TestSetUtteranceText] =
      AwsError.unwrapOptionField("textInput", textInput)
    def getAudioInput: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.UtteranceAudioInputSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("audioInput", audioInput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceInputSpecification
  ) extends zio.aws.lexmodelsv2.model.UtteranceInputSpecification.ReadOnly {
    override val textInput: Optional[TestSetUtteranceText] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textInput())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.TestSetUtteranceText(value)
        )
    override val audioInput: Optional[
      zio.aws.lexmodelsv2.model.UtteranceAudioInputSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.audioInput())
      .map(value =>
        zio.aws.lexmodelsv2.model.UtteranceAudioInputSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UtteranceInputSpecification
  ): zio.aws.lexmodelsv2.model.UtteranceInputSpecification.ReadOnly =
    new Wrapper(impl)
}
