package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestSetExportSpecification(testSetId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetExportSpecification = {
    import TestSetExportSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetExportSpecification
      .builder()
      .testSetId(Id.unwrap(testSetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestSetExportSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetExportSpecification.wrap(buildAwsValue())
}
object TestSetExportSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetExportSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetExportSpecification =
      zio.aws.lexmodelsv2.model.TestSetExportSpecification(testSetId)
    def testSetId: Id
    def getTestSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(testSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetExportSpecification
  ) extends zio.aws.lexmodelsv2.model.TestSetExportSpecification.ReadOnly {
    override val testSetId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetExportSpecification
  ): zio.aws.lexmodelsv2.model.TestSetExportSpecification.ReadOnly =
    new Wrapper(impl)
}
