package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportResourceSpecification(
    botImportSpecification: Optional[
      zio.aws.lexmodelsv2.model.BotImportSpecification
    ] = Optional.Absent,
    botLocaleImportSpecification: Optional[
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification
    ] = Optional.Absent,
    customVocabularyImportSpecification: Optional[
      zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification
    ] = Optional.Absent,
    testSetImportResourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification = {
    import ImportResourceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification
      .builder()
      .optionallyWith(
        botImportSpecification.map(value => value.buildAwsValue())
      )(_.botImportSpecification)
      .optionallyWith(
        botLocaleImportSpecification.map(value => value.buildAwsValue())
      )(_.botLocaleImportSpecification)
      .optionallyWith(
        customVocabularyImportSpecification.map(value => value.buildAwsValue())
      )(_.customVocabularyImportSpecification)
      .optionallyWith(
        testSetImportResourceSpecification.map(value => value.buildAwsValue())
      )(_.testSetImportResourceSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.ImportResourceSpecification.wrap(buildAwsValue())
}
object ImportResourceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ImportResourceSpecification =
      zio.aws.lexmodelsv2.model.ImportResourceSpecification(
        botImportSpecification.map(value => value.asEditable),
        botLocaleImportSpecification.map(value => value.asEditable),
        customVocabularyImportSpecification.map(value => value.asEditable),
        testSetImportResourceSpecification.map(value => value.asEditable)
      )
    def botImportSpecification
        : Optional[zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly]
    def botLocaleImportSpecification: Optional[
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly
    ]
    def customVocabularyImportSpecification: Optional[
      zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification.ReadOnly
    ]
    def testSetImportResourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification.ReadOnly
    ]
    def getBotImportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "botImportSpecification",
      botImportSpecification
    )
    def getBotLocaleImportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "botLocaleImportSpecification",
      botLocaleImportSpecification
    )
    def getCustomVocabularyImportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customVocabularyImportSpecification",
      customVocabularyImportSpecification
    )
    def getTestSetImportResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "testSetImportResourceSpecification",
      testSetImportResourceSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification
  ) extends zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly {
    override val botImportSpecification
        : Optional[zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botImportSpecification())
        .map(value =>
          zio.aws.lexmodelsv2.model.BotImportSpecification.wrap(value)
        )
    override val botLocaleImportSpecification: Optional[
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botLocaleImportSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.wrap(value)
      )
    override val customVocabularyImportSpecification: Optional[
      zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customVocabularyImportSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.CustomVocabularyImportSpecification
          .wrap(value)
      )
    override val testSetImportResourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetImportResourceSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification
  ): zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly =
    new Wrapper(impl)
}
