package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, BotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchUpdateCustomVocabularyItemResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    errors: Optional[
      Iterable[zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem]
    ] = Optional.Absent,
    resources: Optional[
      Iterable[zio.aws.lexmodelsv2.model.CustomVocabularyItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse = {
    import BatchUpdateCustomVocabularyItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse
      .wrap(buildAwsValue())
}
object BatchUpdateCustomVocabularyItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse =
      zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botId: Optional[Id]
    def botVersion: Optional[BotVersion]
    def localeId: Optional[LocaleId]
    def errors: Optional[
      List[zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem.ReadOnly]
    ]
    def resources: Optional[
      List[zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly]
    ]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse
  ) extends zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val errors: Optional[
      List[zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem.wrap(item)
        }.toList
      )
    override val resources: Optional[
      List[zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.CustomVocabularyItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse
  ): zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse.ReadOnly =
    new Wrapper(impl)
}
