package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode
  ): zio.aws.lexmodelsv2.model.ErrorCode = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.DUPLICATE_INPUT =>
      val r = DUPLICATE_INPUT
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.RESOURCE_DOES_NOT_EXIST =>
      val r = RESOURCE_DOES_NOT_EXIST
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.RESOURCE_ALREADY_EXISTS =>
      val r = RESOURCE_ALREADY_EXISTS
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.INTERNAL_SERVER_FAILURE =>
      val r = INTERNAL_SERVER_FAILURE
      r
  }
  case object unknownToSdkVersion extends zio.aws.lexmodelsv2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode =
      software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object DUPLICATE_INPUT extends zio.aws.lexmodelsv2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode =
      software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.DUPLICATE_INPUT
  }
  case object RESOURCE_DOES_NOT_EXIST
      extends zio.aws.lexmodelsv2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode =
      software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.RESOURCE_DOES_NOT_EXIST
  }
  case object RESOURCE_ALREADY_EXISTS
      extends zio.aws.lexmodelsv2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode =
      software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.RESOURCE_ALREADY_EXISTS
  }
  case object INTERNAL_SERVER_FAILURE
      extends zio.aws.lexmodelsv2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode =
      software.amazon.awssdk.services.lexmodelsv2.model.ErrorCode.INTERNAL_SERVER_FAILURE
  }
}
