package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeTestSetRequest(testSetId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest = {
    import DescribeTestSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest
      .builder()
      .testSetId(Id.unwrap(testSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeTestSetRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeTestSetRequest.wrap(buildAwsValue())
}
object DescribeTestSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeTestSetRequest =
      zio.aws.lexmodelsv2.model.DescribeTestSetRequest(testSetId)
    def testSetId: Id
    def getTestSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(testSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeTestSetRequest.ReadOnly {
    override val testSetId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest
  ): zio.aws.lexmodelsv2.model.DescribeTestSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
