package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.ActiveContextName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ActiveContext(name: ActiveContextName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext = {
    import ActiveContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext
      .builder()
      .name(ActiveContextName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly =
    zio.aws.lexmodelsv2.model.ActiveContext.wrap(buildAwsValue())
}
object ActiveContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ActiveContext =
      zio.aws.lexmodelsv2.model.ActiveContext(name)
    def name: ActiveContextName
    def getName: ZIO[Any, Nothing, ActiveContextName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext
  ) extends zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly {
    override val name: ActiveContextName =
      zio.aws.lexmodelsv2.model.primitives.ActiveContextName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext
  ): zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly = new Wrapper(impl)
}
