package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  NumericalBotVersion,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class BotSummary(
    botId: Optional[Id] = Optional.Absent,
    botName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] = Optional.Absent,
    latestBotVersion: Optional[NumericalBotVersion] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    botType: Optional[zio.aws.lexmodelsv2.model.BotType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotSummary = {
    import BotSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotSummary
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        latestBotVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.latestBotVersion)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(botType.map(value => value.unwrap))(_.botType)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BotSummary.wrap(buildAwsValue())
}
object BotSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotSummary =
      zio.aws.lexmodelsv2.model.BotSummary(
        botId.map(value => value),
        botName.map(value => value),
        description.map(value => value),
        botStatus.map(value => value),
        latestBotVersion.map(value => value),
        lastUpdatedDateTime.map(value => value),
        botType.map(value => value)
      )
    def botId: Optional[Id]
    def botName: Optional[Name]
    def description: Optional[Description]
    def botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus]
    def latestBotVersion: Optional[NumericalBotVersion]
    def lastUpdatedDateTime: Optional[Timestamp]
    def botType: Optional[zio.aws.lexmodelsv2.model.BotType]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getLatestBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("latestBotVersion", latestBotVersion)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getBotType: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotType] =
      AwsError.unwrapOptionField("botType", botType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotSummary
  ) extends zio.aws.lexmodelsv2.model.BotSummary.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.botName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val latestBotVersion: Optional[NumericalBotVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestBotVersion())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
        )
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val botType: Optional[zio.aws.lexmodelsv2.model.BotType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botType())
        .map(value => zio.aws.lexmodelsv2.model.BotType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotSummary
  ): zio.aws.lexmodelsv2.model.BotSummary.ReadOnly = new Wrapper(impl)
}
