package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FulfillmentCodeHookSettings(
    enabled: Boolean,
    postFulfillmentStatusSpecification: Optional[
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification
    ] = Optional.Absent,
    fulfillmentUpdatesSpecification: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification
    ] = Optional.Absent,
    active: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings = {
    import FulfillmentCodeHookSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        postFulfillmentStatusSpecification.map(value => value.buildAwsValue())
      )(_.postFulfillmentStatusSpecification)
      .optionallyWith(
        fulfillmentUpdatesSpecification.map(value => value.buildAwsValue())
      )(_.fulfillmentUpdatesSpecification)
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly =
    zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.wrap(buildAwsValue())
}
object FulfillmentCodeHookSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings =
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings(
        enabled,
        postFulfillmentStatusSpecification.map(value => value.asEditable),
        fulfillmentUpdatesSpecification.map(value => value.asEditable),
        active.map(value => value)
      )
    def enabled: Boolean
    def postFulfillmentStatusSpecification: Optional[
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly
    ]
    def fulfillmentUpdatesSpecification: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly
    ]
    def active: Optional[BoxedBoolean]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getPostFulfillmentStatusSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "postFulfillmentStatusSpecification",
      postFulfillmentStatusSpecification
    )
    def getFulfillmentUpdatesSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fulfillmentUpdatesSpecification",
      fulfillmentUpdatesSpecification
    )
    def getActive: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("active", active)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings
  ) extends zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val postFulfillmentStatusSpecification: Optional[
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.postFulfillmentStatusSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.wrap(value)
      )
    override val fulfillmentUpdatesSpecification: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fulfillmentUpdatesSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.wrap(value)
      )
    override val active: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings
  ): zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly =
    new Wrapper(impl)
}
