package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  Timestamp,
  FailureReason,
  SessionTTL,
  Description,
  Name,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeBotResponse(
    botId: Optional[Id] = Optional.Absent,
    botName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    dataPrivacy: Optional[zio.aws.lexmodelsv2.model.DataPrivacy] =
      Optional.Absent,
    idleSessionTTLInSeconds: Optional[SessionTTL] = Optional.Absent,
    botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    botType: Optional[zio.aws.lexmodelsv2.model.BotType] = Optional.Absent,
    botMembers: Optional[Iterable[zio.aws.lexmodelsv2.model.BotMember]] =
      Optional.Absent,
    failureReasons: Optional[Iterable[FailureReason]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse = {
    import DescribeBotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(dataPrivacy.map(value => value.buildAwsValue()))(
        _.dataPrivacy
      )
      .optionallyWith(
        idleSessionTTLInSeconds.map(value => SessionTTL.unwrap(value): Integer)
      )(_.idleSessionTTLInSeconds)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(botType.map(value => value.unwrap))(_.botType)
      .optionallyWith(
        botMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botMembers)
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            FailureReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureReasons)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotResponse.wrap(buildAwsValue())
}
object DescribeBotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotResponse =
      zio.aws.lexmodelsv2.model.DescribeBotResponse(
        botId.map(value => value),
        botName.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        dataPrivacy.map(value => value.asEditable),
        idleSessionTTLInSeconds.map(value => value),
        botStatus.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        botType.map(value => value),
        botMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failureReasons.map(value => value)
      )
    def botId: Optional[Id]
    def botName: Optional[Name]
    def description: Optional[Description]
    def roleArn: Optional[RoleArn]
    def dataPrivacy: Optional[zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly]
    def idleSessionTTLInSeconds: Optional[SessionTTL]
    def botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def botType: Optional[zio.aws.lexmodelsv2.model.BotType]
    def botMembers: Optional[List[zio.aws.lexmodelsv2.model.BotMember.ReadOnly]]
    def failureReasons: Optional[List[FailureReason]]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataPrivacy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] =
      AwsError.unwrapOptionField("dataPrivacy", dataPrivacy)
    def getIdleSessionTTLInSeconds: ZIO[Any, AwsError, SessionTTL] = AwsError
      .unwrapOptionField("idleSessionTTLInSeconds", idleSessionTTLInSeconds)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getBotType: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotType] =
      AwsError.unwrapOptionField("botType", botType)
    def getBotMembers: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotMember.ReadOnly
    ]] = AwsError.unwrapOptionField("botMembers", botMembers)
    def getFailureReasons: ZIO[Any, AwsError, List[FailureReason]] =
      AwsError.unwrapOptionField("failureReasons", failureReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.botName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RoleArn(value))
    override val dataPrivacy
        : Optional[zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataPrivacy())
        .map(value => zio.aws.lexmodelsv2.model.DataPrivacy.wrap(value))
    override val idleSessionTTLInSeconds: Optional[SessionTTL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idleSessionTTLInSeconds())
        .map(value => zio.aws.lexmodelsv2.model.primitives.SessionTTL(value))
    override val botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val botType: Optional[zio.aws.lexmodelsv2.model.BotType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botType())
        .map(value => zio.aws.lexmodelsv2.model.BotType.wrap(value))
    override val botMembers
        : Optional[List[zio.aws.lexmodelsv2.model.BotMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botMembers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotMember.wrap(item)
          }.toList
        )
    override val failureReasons: Optional[List[FailureReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.primitives.FailureReason(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse
  ): zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly = new Wrapper(impl)
}
