package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.PlainTextMessageValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PlainTextMessage(value: PlainTextMessageValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.PlainTextMessage = {
    import PlainTextMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.PlainTextMessage
      .builder()
      .value(PlainTextMessageValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly =
    zio.aws.lexmodelsv2.model.PlainTextMessage.wrap(buildAwsValue())
}
object PlainTextMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.PlainTextMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.PlainTextMessage =
      zio.aws.lexmodelsv2.model.PlainTextMessage(value)
    def value: PlainTextMessageValue
    def getValue: ZIO[Any, Nothing, PlainTextMessageValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PlainTextMessage
  ) extends zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly {
    override val value: PlainTextMessageValue =
      zio.aws.lexmodelsv2.model.primitives.PlainTextMessageValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PlainTextMessage
  ): zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly = new Wrapper(impl)
}
