package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  FailureReason,
  ImportedResourceId,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class DescribeImportResponse(
    importId: Optional[Id] = Optional.Absent,
    resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ImportResourceSpecification
    ] = Optional.Absent,
    importedResourceId: Optional[ImportedResourceId] = Optional.Absent,
    importedResourceName: Optional[Name] = Optional.Absent,
    mergeStrategy: Optional[zio.aws.lexmodelsv2.model.MergeStrategy] =
      Optional.Absent,
    importStatus: Optional[zio.aws.lexmodelsv2.model.ImportStatus] =
      Optional.Absent,
    failureReasons: Optional[Iterable[FailureReason]] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse = {
    import DescribeImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse
      .builder()
      .optionallyWith(
        importId.map(value => Id.unwrap(value): java.lang.String)
      )(_.importId)
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(
        importedResourceId.map(value =>
          ImportedResourceId.unwrap(value): java.lang.String
        )
      )(_.importedResourceId)
      .optionallyWith(
        importedResourceName.map(value => Name.unwrap(value): java.lang.String)
      )(_.importedResourceName)
      .optionallyWith(mergeStrategy.map(value => value.unwrap))(_.mergeStrategy)
      .optionallyWith(importStatus.map(value => value.unwrap))(_.importStatus)
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            FailureReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureReasons)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeImportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeImportResponse.wrap(buildAwsValue())
}
object DescribeImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeImportResponse =
      zio.aws.lexmodelsv2.model.DescribeImportResponse(
        importId.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        importedResourceId.map(value => value),
        importedResourceName.map(value => value),
        mergeStrategy.map(value => value),
        importStatus.map(value => value),
        failureReasons.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def importId: Optional[Id]
    def resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ]
    def importedResourceId: Optional[ImportedResourceId]
    def importedResourceName: Optional[Name]
    def mergeStrategy: Optional[zio.aws.lexmodelsv2.model.MergeStrategy]
    def importStatus: Optional[zio.aws.lexmodelsv2.model.ImportStatus]
    def failureReasons: Optional[List[FailureReason]]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def getImportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("importId", importId)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getImportedResourceId: ZIO[Any, AwsError, ImportedResourceId] =
      AwsError.unwrapOptionField("importedResourceId", importedResourceId)
    def getImportedResourceName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("importedResourceName", importedResourceName)
    def getMergeStrategy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.MergeStrategy] =
      AwsError.unwrapOptionField("mergeStrategy", mergeStrategy)
    def getImportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportStatus] =
      AwsError.unwrapOptionField("importStatus", importStatus)
    def getFailureReasons: ZIO[Any, AwsError, List[FailureReason]] =
      AwsError.unwrapOptionField("failureReasons", failureReasons)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeImportResponse.ReadOnly {
    override val importId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.importId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.ImportResourceSpecification.wrap(value)
      )
    override val importedResourceId: Optional[ImportedResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedResourceId())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ImportedResourceId(value)
        )
    override val importedResourceName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.importedResourceName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val mergeStrategy
        : Optional[zio.aws.lexmodelsv2.model.MergeStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergeStrategy())
        .map(value => zio.aws.lexmodelsv2.model.MergeStrategy.wrap(value))
    override val importStatus
        : Optional[zio.aws.lexmodelsv2.model.ImportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importStatus())
        .map(value => zio.aws.lexmodelsv2.model.ImportStatus.wrap(value))
    override val failureReasons: Optional[List[FailureReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.primitives.FailureReason(item)
          }.toList
        )
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse
  ): zio.aws.lexmodelsv2.model.DescribeImportResponse.ReadOnly = new Wrapper(
    impl
  )
}
