package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.PresignedS3Url
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BotRecommendationResults(
    botLocaleExportUrl: Optional[PresignedS3Url] = Optional.Absent,
    associatedTranscriptsUrl: Optional[PresignedS3Url] = Optional.Absent,
    statistics: Optional[
      zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResults = {
    import BotRecommendationResults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResults
      .builder()
      .optionallyWith(
        botLocaleExportUrl.map(value =>
          PresignedS3Url.unwrap(value): java.lang.String
        )
      )(_.botLocaleExportUrl)
      .optionallyWith(
        associatedTranscriptsUrl.map(value =>
          PresignedS3Url.unwrap(value): java.lang.String
        )
      )(_.associatedTranscriptsUrl)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotRecommendationResults.ReadOnly =
    zio.aws.lexmodelsv2.model.BotRecommendationResults.wrap(buildAwsValue())
}
object BotRecommendationResults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotRecommendationResults =
      zio.aws.lexmodelsv2.model.BotRecommendationResults(
        botLocaleExportUrl.map(value => value),
        associatedTranscriptsUrl.map(value => value),
        statistics.map(value => value.asEditable)
      )
    def botLocaleExportUrl: Optional[PresignedS3Url]
    def associatedTranscriptsUrl: Optional[PresignedS3Url]
    def statistics: Optional[
      zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics.ReadOnly
    ]
    def getBotLocaleExportUrl: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("botLocaleExportUrl", botLocaleExportUrl)
    def getAssociatedTranscriptsUrl: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField(
        "associatedTranscriptsUrl",
        associatedTranscriptsUrl
      )
    def getStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("statistics", statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResults
  ) extends zio.aws.lexmodelsv2.model.BotRecommendationResults.ReadOnly {
    override val botLocaleExportUrl: Optional[PresignedS3Url] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botLocaleExportUrl())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.PresignedS3Url(value)
        )
    override val associatedTranscriptsUrl: Optional[PresignedS3Url] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedTranscriptsUrl())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.PresignedS3Url(value)
        )
    override val statistics: Optional[
      zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statistics())
      .map(value =>
        zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResults
  ): zio.aws.lexmodelsv2.model.BotRecommendationResults.ReadOnly = new Wrapper(
    impl
  )
}
