package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.ConditionExpression
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Condition(expressionString: ConditionExpression) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.Condition
      .builder()
      .expressionString(
        ConditionExpression.unwrap(expressionString): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.Condition.ReadOnly =
    zio.aws.lexmodelsv2.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.Condition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.Condition =
      zio.aws.lexmodelsv2.model.Condition(expressionString)
    def expressionString: ConditionExpression
    def getExpressionString: ZIO[Any, Nothing, ConditionExpression] =
      ZIO.succeed(expressionString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Condition
  ) extends zio.aws.lexmodelsv2.model.Condition.ReadOnly {
    override val expressionString: ConditionExpression =
      zio.aws.lexmodelsv2.model.primitives
        .ConditionExpression(impl.expressionString())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Condition
  ): zio.aws.lexmodelsv2.model.Condition.ReadOnly = new Wrapper(impl)
}
