package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  RevisionId,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteResourcePolicyStatementRequest(
    resourceArn: AmazonResourceName,
    statementId: Name,
    expectedRevisionId: Optional[RevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest = {
    import DeleteResourcePolicyStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .statementId(Name.unwrap(statementId): java.lang.String)
      .optionallyWith(
        expectedRevisionId.map(value =>
          RevisionId.unwrap(value): java.lang.String
        )
      )(_.expectedRevisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementRequest
      .wrap(buildAwsValue())
}
object DeleteResourcePolicyStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementRequest =
      zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementRequest(
        resourceArn,
        statementId,
        expectedRevisionId.map(value => value)
      )
    def resourceArn: AmazonResourceName
    def statementId: Name
    def expectedRevisionId: Optional[RevisionId]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getStatementId: ZIO[Any, Nothing, Name] = ZIO.succeed(statementId)
    def getExpectedRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("expectedRevisionId", expectedRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.lexmodelsv2.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val statementId: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.statementId())
    override val expectedRevisionId: Optional[RevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedRevisionId())
        .map(value => zio.aws.lexmodelsv2.model.primitives.RevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest
  ): zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementRequest.ReadOnly =
    new Wrapper(impl)
}
