package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IntentClosingSetting(
    closingResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    active: Optional[BoxedBoolean] = Optional.Absent,
    nextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] = Optional.Absent,
    conditional: Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting = {
    import IntentClosingSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting
      .builder()
      .optionallyWith(closingResponse.map(value => value.buildAwsValue()))(
        _.closingResponse
      )
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .optionallyWith(nextStep.map(value => value.buildAwsValue()))(_.nextStep)
      .optionallyWith(conditional.map(value => value.buildAwsValue()))(
        _.conditional
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentClosingSetting.wrap(buildAwsValue())
}
object IntentClosingSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentClosingSetting =
      zio.aws.lexmodelsv2.model.IntentClosingSetting(
        closingResponse.map(value => value.asEditable),
        active.map(value => value),
        nextStep.map(value => value.asEditable),
        conditional.map(value => value.asEditable)
      )
    def closingResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def active: Optional[BoxedBoolean]
    def nextStep: Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def conditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def getClosingResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("closingResponse", closingResponse)
    def getActive: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("active", active)
    def getNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("nextStep", nextStep)
    def getConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("conditional", conditional)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting
  ) extends zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly {
    override val closingResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.closingResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val active: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: BoxedBoolean)
    override val nextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val conditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting
  ): zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly = new Wrapper(impl)
}
