package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SubSlotValueElicitationSetting(
    defaultValueSpecification: Optional[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification
    ] = Optional.Absent,
    promptSpecification: zio.aws.lexmodelsv2.model.PromptSpecification,
    sampleUtterances: Optional[
      Iterable[zio.aws.lexmodelsv2.model.SampleUtterance]
    ] = Optional.Absent,
    waitAndContinueSpecification: Optional[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SubSlotValueElicitationSetting = {
    import SubSlotValueElicitationSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SubSlotValueElicitationSetting
      .builder()
      .optionallyWith(
        defaultValueSpecification.map(value => value.buildAwsValue())
      )(_.defaultValueSpecification)
      .promptSpecification(promptSpecification.buildAwsValue())
      .optionallyWith(
        sampleUtterances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sampleUtterances)
      .optionallyWith(
        waitAndContinueSpecification.map(value => value.buildAwsValue())
      )(_.waitAndContinueSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting
      .wrap(buildAwsValue())
}
object SubSlotValueElicitationSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SubSlotValueElicitationSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting =
      zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting(
        defaultValueSpecification.map(value => value.asEditable),
        promptSpecification.asEditable,
        sampleUtterances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        waitAndContinueSpecification.map(value => value.asEditable)
      )
    def defaultValueSpecification: Optional[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ]
    def promptSpecification
        : zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    def sampleUtterances
        : Optional[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]]
    def waitAndContinueSpecification: Optional[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ]
    def getDefaultValueSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultValueSpecification",
      defaultValueSpecification
    )
    def getPromptSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    ] = ZIO.succeed(promptSpecification)
    def getSampleUtterances: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly
    ]] = AwsError.unwrapOptionField("sampleUtterances", sampleUtterances)
    def getWaitAndContinueSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "waitAndContinueSpecification",
      waitAndContinueSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SubSlotValueElicitationSetting
  ) extends zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting.ReadOnly {
    override val defaultValueSpecification: Optional[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValueSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.wrap(value)
      )
    override val promptSpecification
        : zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.PromptSpecification
        .wrap(impl.promptSpecification())
    override val sampleUtterances
        : Optional[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleUtterances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SampleUtterance.wrap(item)
          }.toList
        )
    override val waitAndContinueSpecification: Optional[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.waitAndContinueSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SubSlotValueElicitationSetting
  ): zio.aws.lexmodelsv2.model.SubSlotValueElicitationSetting.ReadOnly =
    new Wrapper(impl)
}
