package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  LocaleId,
  BotVersion,
  Id
}
import scala.jdk.CollectionConverters.*
final case class DescribeCustomVocabularyMetadataResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    customVocabularyStatus: Optional[
      zio.aws.lexmodelsv2.model.CustomVocabularyStatus
    ] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse = {
    import DescribeCustomVocabularyMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(customVocabularyStatus.map(value => value.unwrap))(
        _.customVocabularyStatus
      )
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse
      .wrap(buildAwsValue())
}
object DescribeCustomVocabularyMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse =
      zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        customVocabularyStatus.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[BotVersion]
    def localeId: Optional[LocaleId]
    def customVocabularyStatus
        : Optional[zio.aws.lexmodelsv2.model.CustomVocabularyStatus]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getCustomVocabularyStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.CustomVocabularyStatus] =
      AwsError.unwrapOptionField(
        "customVocabularyStatus",
        customVocabularyStatus
      )
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val customVocabularyStatus
        : Optional[zio.aws.lexmodelsv2.model.CustomVocabularyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customVocabularyStatus())
        .map(value =>
          zio.aws.lexmodelsv2.model.CustomVocabularyStatus.wrap(value)
        )
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse
  ): zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
