package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait MergeStrategy {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy
}
object MergeStrategy {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy
  ): zio.aws.lexmodelsv2.model.MergeStrategy = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy.OVERWRITE =>
      val r = Overwrite
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy.FAIL_ON_CONFLICT =>
      val r = FailOnConflict
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy.APPEND =>
      val r = Append
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.MergeStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object Overwrite extends zio.aws.lexmodelsv2.model.MergeStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy.OVERWRITE
  }
  case object FailOnConflict extends zio.aws.lexmodelsv2.model.MergeStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy.FAIL_ON_CONFLICT
  }
  case object Append extends zio.aws.lexmodelsv2.model.MergeStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy.APPEND
  }
}
