package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.SSMLMessageValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SSMLMessage(value: SSMLMessageValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SSMLMessage = {
    import SSMLMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SSMLMessage
      .builder()
      .value(SSMLMessageValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly =
    zio.aws.lexmodelsv2.model.SSMLMessage.wrap(buildAwsValue())
}
object SSMLMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SSMLMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SSMLMessage =
      zio.aws.lexmodelsv2.model.SSMLMessage(value)
    def value: SSMLMessageValue
    def getValue: ZIO[Any, Nothing, SSMLMessageValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SSMLMessage
  ) extends zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly {
    override val value: SSMLMessageValue =
      zio.aws.lexmodelsv2.model.primitives.SSMLMessageValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SSMLMessage
  ): zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly = new Wrapper(impl)
}
