package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultConditionalBranch(
    nextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] = Optional.Absent,
    response: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DefaultConditionalBranch = {
    import DefaultConditionalBranch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DefaultConditionalBranch
      .builder()
      .optionallyWith(nextStep.map(value => value.buildAwsValue()))(_.nextStep)
      .optionallyWith(response.map(value => value.buildAwsValue()))(_.response)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DefaultConditionalBranch.ReadOnly =
    zio.aws.lexmodelsv2.model.DefaultConditionalBranch.wrap(buildAwsValue())
}
object DefaultConditionalBranch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DefaultConditionalBranch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DefaultConditionalBranch =
      zio.aws.lexmodelsv2.model.DefaultConditionalBranch(
        nextStep.map(value => value.asEditable),
        response.map(value => value.asEditable)
      )
    def nextStep: Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def response
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def getNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("nextStep", nextStep)
    def getResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("response", response)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DefaultConditionalBranch
  ) extends zio.aws.lexmodelsv2.model.DefaultConditionalBranch.ReadOnly {
    override val nextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val response
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.response())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DefaultConditionalBranch
  ): zio.aws.lexmodelsv2.model.DefaultConditionalBranch.ReadOnly = new Wrapper(
    impl
  )
}
