package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BotFilter(
    name: zio.aws.lexmodelsv2.model.BotFilterName,
    values: Iterable[FilterValue],
    operator: zio.aws.lexmodelsv2.model.BotFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotFilter = {
    import BotFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.BotFilter.wrap(buildAwsValue())
}
object BotFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotFilter =
      zio.aws.lexmodelsv2.model.BotFilter(name, values, operator)
    def name: zio.aws.lexmodelsv2.model.BotFilterName
    def values: List[FilterValue]
    def operator: zio.aws.lexmodelsv2.model.BotFilterOperator
    def getName: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.BotFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.BotFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotFilter
  ) extends zio.aws.lexmodelsv2.model.BotFilter.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.BotFilterName =
      zio.aws.lexmodelsv2.model.BotFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
    override val operator: zio.aws.lexmodelsv2.model.BotFilterOperator =
      zio.aws.lexmodelsv2.model.BotFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotFilter
  ): zio.aws.lexmodelsv2.model.BotFilter.ReadOnly = new Wrapper(impl)
}
