package zio.aws.lexmodelsv2
import zio.aws.lexmodelsv2.model.ListBotRecommendationsResponse.ReadOnly
import zio.aws.lexmodelsv2.model.{
  UpdateSlotTypeRequest,
  DeleteBotLocaleRequest,
  UpdateExportRequest,
  DeleteResourcePolicyStatementRequest,
  DescribeBotRecommendationRequest,
  CreateIntentRequest,
  CreateBotRequest,
  ListIntentsRequest,
  ListBotAliasesRequest,
  ListRecommendedIntentsRequest,
  DescribeBotRequest,
  SearchAssociatedTranscriptsRequest,
  DeleteBotAliasRequest,
  DescribeImportRequest,
  ListSlotTypesRequest,
  ListAggregatedUtterancesRequest,
  ListCustomVocabularyItemsRequest,
  DeleteBotRequest,
  ListSlotsRequest,
  DeleteIntentRequest,
  ListBotRecommendationsRequest,
  DeleteExportRequest,
  ListImportsRequest,
  DeleteBotVersionRequest,
  CreateUploadUrlRequest,
  CreateSlotRequest,
  UpdateBotRecommendationRequest,
  UpdateResourcePolicyRequest,
  ListTagsForResourceRequest,
  BatchDeleteCustomVocabularyItemRequest,
  CreateSlotTypeRequest,
  DescribeIntentRequest,
  DeleteCustomVocabularyRequest,
  ListBotsRequest,
  ListBuiltInIntentsRequest,
  ListExportsRequest,
  DeleteUtterancesRequest,
  ListBotLocalesRequest,
  ListBotVersionsRequest,
  CreateResourcePolicyRequest,
  UpdateIntentRequest,
  DescribeBotVersionRequest,
  UpdateSlotRequest,
  CreateExportRequest,
  CreateBotLocaleRequest,
  UpdateBotAliasRequest,
  BatchCreateCustomVocabularyItemRequest,
  DescribeBotAliasRequest,
  DescribeBotLocaleRequest,
  DescribeSlotRequest,
  ListBuiltInSlotTypesRequest,
  BuildBotLocaleRequest,
  DescribeSlotTypeRequest,
  StartBotRecommendationRequest,
  DeleteResourcePolicyRequest,
  UntagResourceRequest,
  UpdateBotRequest,
  CreateBotVersionRequest,
  DeleteImportRequest,
  DeleteSlotRequest,
  DescribeCustomVocabularyMetadataRequest,
  DeleteSlotTypeRequest,
  DescribeResourcePolicyRequest,
  CreateResourcePolicyStatementRequest,
  DescribeExportRequest,
  CreateBotAliasRequest,
  UpdateBotLocaleRequest,
  BatchUpdateCustomVocabularyItemRequest,
  TagResourceRequest,
  StartImportRequest,
  StopBotRecommendationRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.lexmodelsv2.model.{
  DescribeIntentResponse,
  DescribeSlotTypeResponse,
  CreateBotVersionResponse,
  ListExportsResponse,
  UpdateBotLocaleResponse,
  UpdateSlotResponse,
  ListRecommendedIntentsResponse,
  DescribeExportResponse,
  DescribeBotLocaleResponse,
  DeleteResourcePolicyStatementResponse,
  StartImportResponse,
  DeleteUtterancesResponse,
  DeleteBotLocaleResponse,
  ListSlotsResponse,
  DeleteSlotResponse,
  DescribeBotRecommendationResponse,
  StartBotRecommendationResponse,
  ListBotRecommendationsResponse,
  DescribeResourcePolicyResponse,
  UpdateBotRecommendationResponse,
  UpdateResourcePolicyResponse,
  DeleteSlotTypeResponse,
  BatchUpdateCustomVocabularyItemResponse,
  ListSlotTypesResponse,
  DeleteBotAliasResponse,
  DeleteExportResponse,
  DescribeSlotResponse,
  BatchCreateCustomVocabularyItemResponse,
  CreateSlotTypeResponse,
  CreateSlotResponse,
  ListBotLocalesResponse,
  DescribeCustomVocabularyMetadataResponse,
  ListCustomVocabularyItemsResponse,
  ListBuiltInSlotTypesResponse,
  BuildBotLocaleResponse,
  CreateExportResponse,
  CreateResourcePolicyResponse,
  UpdateBotResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteImportResponse,
  DeleteIntentResponse,
  CreateResourcePolicyStatementResponse,
  UpdateSlotTypeResponse,
  DeleteCustomVocabularyResponse,
  BatchDeleteCustomVocabularyItemResponse,
  UpdateIntentResponse,
  ListBotsResponse,
  CreateUploadUrlResponse,
  DeleteBotVersionResponse,
  UpdateExportResponse,
  CreateBotAliasResponse,
  ListIntentsResponse,
  CreateBotLocaleResponse,
  ListImportsResponse,
  CreateBotResponse,
  DeleteResourcePolicyResponse,
  DescribeImportResponse,
  TagResourceResponse,
  ListBotVersionsResponse,
  StopBotRecommendationResponse,
  DescribeBotVersionResponse,
  CreateIntentResponse,
  DescribeBotResponse,
  DescribeBotAliasResponse,
  SearchAssociatedTranscriptsResponse,
  ListBotAliasesResponse,
  ListAggregatedUtterancesResponse,
  UpdateBotAliasResponse,
  ListBuiltInIntentsResponse,
  DeleteBotResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.lexmodelsv2.{
  LexModelsV2AsyncClientBuilder,
  LexModelsV2AsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters.*
trait LexModelsV2 extends AspectSupport[LexModelsV2] {
  val api: LexModelsV2AsyncClient
  def createResourcePolicyStatement(
      request: CreateResourcePolicyStatementRequest
  ): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.ReadOnly
  ]
  def listSlots(
      request: ListSlotsRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListSlotsResponse.ReadOnly]
  def stopBotRecommendation(request: StopBotRecommendationRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.StopBotRecommendationResponse.ReadOnly
  ]
  def batchUpdateCustomVocabularyItem(
      request: BatchUpdateCustomVocabularyItemRequest
  ): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse.ReadOnly
  ]
  def createBotVersion(
      request: CreateBotVersionRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateBotVersionResponse.ReadOnly]
  def listBotAliases(
      request: ListBotAliasesRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly]
  def updateBot(
      request: UpdateBotRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateBotResponse.ReadOnly]
  def listBotVersions(
      request: ListBotVersionsRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListBotVersionsResponse.ReadOnly]
  def createBotLocale(
      request: CreateBotLocaleRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.ReadOnly]
  def listIntents(
      request: ListIntentsRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly]
  def createUploadUrl(
      request: CreateUploadUrlRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly]
  def describeIntent(
      request: DescribeIntentRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeIntentResponse.ReadOnly]
  def startBotRecommendation(request: StartBotRecommendationRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.StartBotRecommendationResponse.ReadOnly
  ]
  def describeSlot(
      request: DescribeSlotRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeSlotResponse.ReadOnly]
  def deleteSlotType(request: DeleteSlotTypeRequest): IO[AwsError, Unit]
  def listImports(
      request: ListImportsRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly]
  def startImport(
      request: StartImportRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly]
  def updateSlot(
      request: UpdateSlotRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateSlotResponse.ReadOnly]
  def updateSlotType(
      request: UpdateSlotTypeRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.ReadOnly]
  def batchCreateCustomVocabularyItem(
      request: BatchCreateCustomVocabularyItemRequest
  ): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse.ReadOnly
  ]
  def updateExport(
      request: UpdateExportRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly]
  def describeBotLocale(
      request: DescribeBotLocaleRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly]
  def listAggregatedUtterances(request: ListAggregatedUtterancesRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly
  ]
  def searchAssociatedTranscripts(
      request: SearchAssociatedTranscriptsRequest
  ): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.ReadOnly
  ]
  def deleteSlot(request: DeleteSlotRequest): IO[AwsError, Unit]
  def deleteResourcePolicyStatement(
      request: DeleteResourcePolicyStatementRequest
  ): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementResponse.ReadOnly
  ]
  def updateBotLocale(
      request: UpdateBotLocaleRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.ReadOnly]
  def describeBotAlias(
      request: DescribeBotAliasRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.ReadOnly]
  def describeExport(
      request: DescribeExportRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeExportResponse.ReadOnly]
  def listExports(
      request: ListExportsRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly]
  def updateBotAlias(
      request: UpdateBotAliasRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.ReadOnly]
  def describeSlotType(
      request: DescribeSlotTypeRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.ReadOnly]
  def deleteUtterances(
      request: DeleteUtterancesRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteUtterancesResponse.ReadOnly]
  def describeBotRecommendation(request: DescribeBotRecommendationRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeBotRecommendationResponse.ReadOnly
  ]
  def updateIntent(
      request: UpdateIntentRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateIntentResponse.ReadOnly]
  def createBotAlias(
      request: CreateBotAliasRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly]
  def buildBotLocale(
      request: BuildBotLocaleRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.ReadOnly]
  def listBuiltInIntents(
      request: ListBuiltInIntentsRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly]
  def updateBotRecommendation(request: UpdateBotRecommendationRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly
  ]
  def batchDeleteCustomVocabularyItem(
      request: BatchDeleteCustomVocabularyItemRequest
  ): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse.ReadOnly
  ]
  def deleteBotAlias(
      request: DeleteBotAliasRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly]
  def deleteBotLocale(
      request: DeleteBotLocaleRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.ReadOnly]
  def updateResourcePolicy(request: UpdateResourcePolicyRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.ReadOnly
  ]
  def deleteBotVersion(
      request: DeleteBotVersionRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly]
  def deleteExport(
      request: DeleteExportRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteExportResponse.ReadOnly]
  def listBotLocales(
      request: ListBotLocalesRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.UntagResourceResponse.ReadOnly]
  def createIntent(
      request: CreateIntentRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateIntentResponse.ReadOnly]
  def listBots(
      request: ListBotsRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly]
  def createSlotType(
      request: CreateSlotTypeRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateSlotTypeResponse.ReadOnly]
  def describeImport(
      request: DescribeImportRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeImportResponse.ReadOnly]
  def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteResourcePolicyResponse.ReadOnly
  ]
  def createBot(
      request: CreateBotRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateBotResponse.ReadOnly]
  def createSlot(
      request: CreateSlotRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateSlotResponse.ReadOnly]
  def describeBot(
      request: DescribeBotRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly]
  def deleteIntent(request: DeleteIntentRequest): IO[AwsError, Unit]
  def listRecommendedIntents(request: ListRecommendedIntentsRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.ListTagsForResourceResponse.ReadOnly
  ]
  def listBotRecommendations(
      request: ListBotRecommendationsRequest
  ): IO[AwsError, ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.TagResourceResponse.ReadOnly]
  def describeBotVersion(
      request: DescribeBotVersionRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.ReadOnly]
  def describeResourcePolicy(request: DescribeResourcePolicyRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.ReadOnly
  ]
  def deleteImport(
      request: DeleteImportRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteImportResponse.ReadOnly]
  def createExport(
      request: CreateExportRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly]
  def createResourcePolicy(request: CreateResourcePolicyRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.CreateResourcePolicyResponse.ReadOnly
  ]
  def listSlotTypes(
      request: ListSlotTypesRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.ListSlotTypesResponse.ReadOnly]
  def listBuiltInSlotTypes(request: ListBuiltInSlotTypesRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.ReadOnly
  ]
  def listCustomVocabularyItems(request: ListCustomVocabularyItemsRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse.ReadOnly
  ]
  def deleteBot(
      request: DeleteBotRequest
  ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteBotResponse.ReadOnly]
  def deleteCustomVocabulary(request: DeleteCustomVocabularyRequest): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.ReadOnly
  ]
  def describeCustomVocabularyMetadata(
      request: DescribeCustomVocabularyMetadataRequest
  ): IO[
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.ReadOnly
  ]
}
object LexModelsV2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, LexModelsV2] = customized(
    identity
  )
  def customized(
      customization: LexModelsV2AsyncClientBuilder => LexModelsV2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LexModelsV2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: LexModelsV2AsyncClientBuilder => LexModelsV2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, LexModelsV2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = LexModelsV2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[LexModelsV2AsyncClient, LexModelsV2AsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      LexModelsV2AsyncClient,
      LexModelsV2AsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new LexModelsV2Impl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class LexModelsV2Impl[R](
      override val api: LexModelsV2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends LexModelsV2
      with AwsServiceBase[R] {
    override val serviceName: String = "LexModelsV2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LexModelsV2Impl[R1] = new LexModelsV2Impl(api, newAspect, r)
    def createResourcePolicyStatement(
        request: CreateResourcePolicyStatementRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest,
      CreateResourcePolicyStatementResponse
    ]("createResourcePolicyStatement", api.createResourcePolicyStatement)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.wrap)
      .provideEnvironment(r)
    def listSlots(
        request: ListSlotsRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.ListSlotsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest,
        ListSlotsResponse
      ]("listSlots", api.listSlots)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.ListSlotsResponse.wrap)
        .provideEnvironment(r)
    def stopBotRecommendation(request: StopBotRecommendationRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.StopBotRecommendationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationRequest,
      StopBotRecommendationResponse
    ]("stopBotRecommendation", api.stopBotRecommendation)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.StopBotRecommendationResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateCustomVocabularyItem(
        request: BatchUpdateCustomVocabularyItemRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemRequest,
      BatchUpdateCustomVocabularyItemResponse
    ]("batchUpdateCustomVocabularyItem", api.batchUpdateCustomVocabularyItem)(
      request.buildAwsValue()
    ).map(
      zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse.wrap
    ).provideEnvironment(r)
    def createBotVersion(request: CreateBotVersionRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.CreateBotVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest,
      CreateBotVersionResponse
    ]("createBotVersion", api.createBotVersion)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.CreateBotVersionResponse.wrap)
      .provideEnvironment(r)
    def listBotAliases(
        request: ListBotAliasesRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest,
        ListBotAliasesResponse
      ]("listBotAliases", api.listBotAliases)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.ListBotAliasesResponse.wrap)
        .provideEnvironment(r)
    def updateBot(
        request: UpdateBotRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateBotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest,
        UpdateBotResponse
      ]("updateBot", api.updateBot)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.UpdateBotResponse.wrap)
        .provideEnvironment(r)
    def listBotVersions(request: ListBotVersionsRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.ListBotVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest,
      ListBotVersionsResponse
    ]("listBotVersions", api.listBotVersions)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.ListBotVersionsResponse.wrap)
      .provideEnvironment(r)
    def createBotLocale(request: CreateBotLocaleRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest,
      CreateBotLocaleResponse
    ]("createBotLocale", api.createBotLocale)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.wrap)
      .provideEnvironment(r)
    def listIntents(
        request: ListIntentsRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest,
        ListIntentsResponse
      ]("listIntents", api.listIntents)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.ListIntentsResponse.wrap)
        .provideEnvironment(r)
    def createUploadUrl(request: CreateUploadUrlRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlRequest,
      CreateUploadUrlResponse
    ]("createUploadUrl", api.createUploadUrl)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.wrap)
      .provideEnvironment(r)
    def describeIntent(
        request: DescribeIntentRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeIntentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest,
        DescribeIntentResponse
      ]("describeIntent", api.describeIntent)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DescribeIntentResponse.wrap)
        .provideEnvironment(r)
    def startBotRecommendation(request: StartBotRecommendationRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.StartBotRecommendationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest,
      StartBotRecommendationResponse
    ]("startBotRecommendation", api.startBotRecommendation)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.StartBotRecommendationResponse.wrap)
      .provideEnvironment(r)
    def describeSlot(
        request: DescribeSlotRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeSlotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest,
        DescribeSlotResponse
      ]("describeSlot", api.describeSlot)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DescribeSlotResponse.wrap)
        .provideEnvironment(r)
    def deleteSlotType(request: DeleteSlotTypeRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest,
        DeleteSlotTypeResponse
      ]("deleteSlotType", api.deleteSlotType)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listImports(
        request: ListImportsRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest,
        ListImportsResponse
      ]("listImports", api.listImports)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.ListImportsResponse.wrap)
        .provideEnvironment(r)
    def startImport(
        request: StartImportRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest,
        StartImportResponse
      ]("startImport", api.startImport)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.StartImportResponse.wrap)
        .provideEnvironment(r)
    def updateSlot(
        request: UpdateSlotRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateSlotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest,
        UpdateSlotResponse
      ]("updateSlot", api.updateSlot)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.UpdateSlotResponse.wrap)
        .provideEnvironment(r)
    def updateSlotType(
        request: UpdateSlotTypeRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest,
        UpdateSlotTypeResponse
      ]("updateSlotType", api.updateSlotType)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.wrap)
        .provideEnvironment(r)
    def batchCreateCustomVocabularyItem(
        request: BatchCreateCustomVocabularyItemRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemRequest,
      BatchCreateCustomVocabularyItemResponse
    ]("batchCreateCustomVocabularyItem", api.batchCreateCustomVocabularyItem)(
      request.buildAwsValue()
    ).map(
      zio.aws.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse.wrap
    ).provideEnvironment(r)
    def updateExport(
        request: UpdateExportRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest,
        UpdateExportResponse
      ]("updateExport", api.updateExport)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.UpdateExportResponse.wrap)
        .provideEnvironment(r)
    def describeBotLocale(request: DescribeBotLocaleRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest,
      DescribeBotLocaleResponse
    ]("describeBotLocale", api.describeBotLocale)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.wrap)
      .provideEnvironment(r)
    def listAggregatedUtterances(request: ListAggregatedUtterancesRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest,
      ListAggregatedUtterancesResponse
    ]("listAggregatedUtterances", api.listAggregatedUtterances)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.wrap)
      .provideEnvironment(r)
    def searchAssociatedTranscripts(
        request: SearchAssociatedTranscriptsRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest,
      SearchAssociatedTranscriptsResponse
    ]("searchAssociatedTranscripts", api.searchAssociatedTranscripts)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.wrap)
      .provideEnvironment(r)
    def deleteSlot(request: DeleteSlotRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest,
        DeleteSlotResponse
      ]("deleteSlot", api.deleteSlot)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteResourcePolicyStatement(
        request: DeleteResourcePolicyStatementRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest,
      DeleteResourcePolicyStatementResponse
    ]("deleteResourcePolicyStatement", api.deleteResourcePolicyStatement)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementResponse.wrap)
      .provideEnvironment(r)
    def updateBotLocale(request: UpdateBotLocaleRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest,
      UpdateBotLocaleResponse
    ]("updateBotLocale", api.updateBotLocale)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.wrap)
      .provideEnvironment(r)
    def describeBotAlias(request: DescribeBotAliasRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest,
      DescribeBotAliasResponse
    ]("describeBotAlias", api.describeBotAlias)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.wrap)
      .provideEnvironment(r)
    def describeExport(
        request: DescribeExportRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeExportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest,
        DescribeExportResponse
      ]("describeExport", api.describeExport)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DescribeExportResponse.wrap)
        .provideEnvironment(r)
    def listExports(
        request: ListExportsRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest,
        ListExportsResponse
      ]("listExports", api.listExports)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.ListExportsResponse.wrap)
        .provideEnvironment(r)
    def updateBotAlias(
        request: UpdateBotAliasRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest,
        UpdateBotAliasResponse
      ]("updateBotAlias", api.updateBotAlias)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.wrap)
        .provideEnvironment(r)
    def describeSlotType(request: DescribeSlotTypeRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest,
      DescribeSlotTypeResponse
    ]("describeSlotType", api.describeSlotType)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.wrap)
      .provideEnvironment(r)
    def deleteUtterances(request: DeleteUtterancesRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DeleteUtterancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest,
      DeleteUtterancesResponse
    ]("deleteUtterances", api.deleteUtterances)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.DeleteUtterancesResponse.wrap)
      .provideEnvironment(r)
    def describeBotRecommendation(
        request: DescribeBotRecommendationRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DescribeBotRecommendationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest,
      DescribeBotRecommendationResponse
    ]("describeBotRecommendation", api.describeBotRecommendation)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.DescribeBotRecommendationResponse.wrap)
      .provideEnvironment(r)
    def updateIntent(
        request: UpdateIntentRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.UpdateIntentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest,
        UpdateIntentResponse
      ]("updateIntent", api.updateIntent)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.UpdateIntentResponse.wrap)
        .provideEnvironment(r)
    def createBotAlias(
        request: CreateBotAliasRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest,
        CreateBotAliasResponse
      ]("createBotAlias", api.createBotAlias)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.CreateBotAliasResponse.wrap)
        .provideEnvironment(r)
    def buildBotLocale(
        request: BuildBotLocaleRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest,
        BuildBotLocaleResponse
      ]("buildBotLocale", api.buildBotLocale)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.wrap)
        .provideEnvironment(r)
    def listBuiltInIntents(request: ListBuiltInIntentsRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest,
      ListBuiltInIntentsResponse
    ]("listBuiltInIntents", api.listBuiltInIntents)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.wrap)
      .provideEnvironment(r)
    def updateBotRecommendation(request: UpdateBotRecommendationRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest,
      UpdateBotRecommendationResponse
    ]("updateBotRecommendation", api.updateBotRecommendation)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteCustomVocabularyItem(
        request: BatchDeleteCustomVocabularyItemRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest,
      BatchDeleteCustomVocabularyItemResponse
    ]("batchDeleteCustomVocabularyItem", api.batchDeleteCustomVocabularyItem)(
      request.buildAwsValue()
    ).map(
      zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse.wrap
    ).provideEnvironment(r)
    def deleteBotAlias(
        request: DeleteBotAliasRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest,
        DeleteBotAliasResponse
      ]("deleteBotAlias", api.deleteBotAlias)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.wrap)
        .provideEnvironment(r)
    def deleteBotLocale(request: DeleteBotLocaleRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest,
      DeleteBotLocaleResponse
    ]("deleteBotLocale", api.deleteBotLocale)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.wrap)
      .provideEnvironment(r)
    def updateResourcePolicy(request: UpdateResourcePolicyRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest,
      UpdateResourcePolicyResponse
    ]("updateResourcePolicy", api.updateResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteBotVersion(request: DeleteBotVersionRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest,
      DeleteBotVersionResponse
    ]("deleteBotVersion", api.deleteBotVersion)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteExport(
        request: DeleteExportRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteExportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest,
        DeleteExportResponse
      ]("deleteExport", api.deleteExport)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DeleteExportResponse.wrap)
        .provideEnvironment(r)
    def listBotLocales(
        request: ListBotLocalesRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest,
        ListBotLocalesResponse
      ]("listBotLocales", api.listBotLocales)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.ListBotLocalesResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createIntent(
        request: CreateIntentRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateIntentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest,
        CreateIntentResponse
      ]("createIntent", api.createIntent)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.CreateIntentResponse.wrap)
        .provideEnvironment(r)
    def listBots(
        request: ListBotsRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest,
        ListBotsResponse
      ]("listBots", api.listBots)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.ListBotsResponse.wrap)
        .provideEnvironment(r)
    def createSlotType(
        request: CreateSlotTypeRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateSlotTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest,
        CreateSlotTypeResponse
      ]("createSlotType", api.createSlotType)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.CreateSlotTypeResponse.wrap)
        .provideEnvironment(r)
    def describeImport(
        request: DescribeImportRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeImportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest,
        DescribeImportResponse
      ]("describeImport", api.describeImport)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DescribeImportResponse.wrap)
        .provideEnvironment(r)
    def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DeleteResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.DeleteResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def createBot(
        request: CreateBotRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateBotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest,
        CreateBotResponse
      ]("createBot", api.createBot)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.CreateBotResponse.wrap)
        .provideEnvironment(r)
    def createSlot(
        request: CreateSlotRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateSlotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest,
        CreateSlotResponse
      ]("createSlot", api.createSlot)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.CreateSlotResponse.wrap)
        .provideEnvironment(r)
    def describeBot(
        request: DescribeBotRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest,
        DescribeBotResponse
      ]("describeBot", api.describeBot)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DescribeBotResponse.wrap)
        .provideEnvironment(r)
    def deleteIntent(request: DeleteIntentRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest,
        DeleteIntentResponse
      ]("deleteIntent", api.deleteIntent)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listRecommendedIntents(request: ListRecommendedIntentsRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest,
      ListRecommendedIntentsResponse
    ]("listRecommendedIntents", api.listRecommendedIntents)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listBotRecommendations(
        request: ListBotRecommendationsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest,
      ListBotRecommendationsResponse
    ]("listBotRecommendations", api.listBotRecommendations)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.ListBotRecommendationsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeBotVersion(request: DescribeBotVersionRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest,
      DescribeBotVersionResponse
    ]("describeBotVersion", api.describeBotVersion)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.wrap)
      .provideEnvironment(r)
    def describeResourcePolicy(request: DescribeResourcePolicyRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest,
      DescribeResourcePolicyResponse
    ]("describeResourcePolicy", api.describeResourcePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteImport(
        request: DeleteImportRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteImportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest,
        DeleteImportResponse
      ]("deleteImport", api.deleteImport)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DeleteImportResponse.wrap)
        .provideEnvironment(r)
    def createExport(
        request: CreateExportRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest,
        CreateExportResponse
      ]("createExport", api.createExport)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.CreateExportResponse.wrap)
        .provideEnvironment(r)
    def createResourcePolicy(request: CreateResourcePolicyRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.CreateResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest,
      CreateResourcePolicyResponse
    ]("createResourcePolicy", api.createResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.CreateResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def listSlotTypes(
        request: ListSlotTypesRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.ListSlotTypesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest,
        ListSlotTypesResponse
      ]("listSlotTypes", api.listSlotTypes)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.ListSlotTypesResponse.wrap)
        .provideEnvironment(r)
    def listBuiltInSlotTypes(request: ListBuiltInSlotTypesRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest,
      ListBuiltInSlotTypesResponse
    ]("listBuiltInSlotTypes", api.listBuiltInSlotTypes)(request.buildAwsValue())
      .map(zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.wrap)
      .provideEnvironment(r)
    def listCustomVocabularyItems(
        request: ListCustomVocabularyItemsRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest,
      ListCustomVocabularyItemsResponse
    ]("listCustomVocabularyItems", api.listCustomVocabularyItems)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse.wrap)
      .provideEnvironment(r)
    def deleteBot(
        request: DeleteBotRequest
    ): IO[AwsError, zio.aws.lexmodelsv2.model.DeleteBotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest,
        DeleteBotResponse
      ]("deleteBot", api.deleteBot)(request.buildAwsValue())
        .map(zio.aws.lexmodelsv2.model.DeleteBotResponse.wrap)
        .provideEnvironment(r)
    def deleteCustomVocabulary(request: DeleteCustomVocabularyRequest): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest,
      DeleteCustomVocabularyResponse
    ]("deleteCustomVocabulary", api.deleteCustomVocabulary)(
      request.buildAwsValue()
    ).map(zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.wrap)
      .provideEnvironment(r)
    def describeCustomVocabularyMetadata(
        request: DescribeCustomVocabularyMetadataRequest
    ): IO[
      AwsError,
      zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataRequest,
      DescribeCustomVocabularyMetadataResponse
    ]("describeCustomVocabularyMetadata", api.describeCustomVocabularyMetadata)(
      request.buildAwsValue()
    ).map(
      zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.wrap
    ).provideEnvironment(r)
  }
  def createResourcePolicyStatement(
      request: CreateResourcePolicyStatementRequest
  ): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResourcePolicyStatement(request))
  def listSlots(request: ListSlotsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListSlotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSlots(request))
  def stopBotRecommendation(request: StopBotRecommendationRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.StopBotRecommendationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopBotRecommendation(request))
  def batchUpdateCustomVocabularyItem(
      request: BatchUpdateCustomVocabularyItemRequest
  ): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateCustomVocabularyItem(request))
  def createBotVersion(request: CreateBotVersionRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateBotVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBotVersion(request))
  def listBotAliases(request: ListBotAliasesRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBotAliases(request))
  def updateBot(request: UpdateBotRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateBotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBot(request))
  def listBotVersions(request: ListBotVersionsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListBotVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBotVersions(request))
  def createBotLocale(request: CreateBotLocaleRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBotLocale(request))
  def listIntents(request: ListIntentsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIntents(request))
  def createUploadUrl(request: CreateUploadUrlRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUploadUrl(request))
  def describeIntent(request: DescribeIntentRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeIntentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIntent(request))
  def startBotRecommendation(request: StartBotRecommendationRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.StartBotRecommendationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startBotRecommendation(request))
  def describeSlot(request: DescribeSlotRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeSlotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSlot(request))
  def deleteSlotType(
      request: DeleteSlotTypeRequest
  ): ZIO[zio.aws.lexmodelsv2.LexModelsV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSlotType(request))
  def listImports(request: ListImportsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImports(request))
  def startImport(request: StartImportRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startImport(request))
  def updateSlot(request: UpdateSlotRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateSlotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSlot(request))
  def updateSlotType(request: UpdateSlotTypeRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSlotType(request))
  def batchCreateCustomVocabularyItem(
      request: BatchCreateCustomVocabularyItemRequest
  ): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchCreateCustomVocabularyItem(request))
  def updateExport(request: UpdateExportRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateExport(request))
  def describeBotLocale(request: DescribeBotLocaleRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBotLocale(request))
  def listAggregatedUtterances(request: ListAggregatedUtterancesRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAggregatedUtterances(request))
  def searchAssociatedTranscripts(
      request: SearchAssociatedTranscriptsRequest
  ): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchAssociatedTranscripts(request))
  def deleteSlot(
      request: DeleteSlotRequest
  ): ZIO[zio.aws.lexmodelsv2.LexModelsV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSlot(request))
  def deleteResourcePolicyStatement(
      request: DeleteResourcePolicyStatementRequest
  ): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicyStatement(request))
  def updateBotLocale(request: UpdateBotLocaleRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBotLocale(request))
  def describeBotAlias(request: DescribeBotAliasRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBotAlias(request))
  def describeExport(request: DescribeExportRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExport(request))
  def listExports(request: ListExportsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExports(request))
  def updateBotAlias(request: UpdateBotAliasRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBotAlias(request))
  def describeSlotType(request: DescribeSlotTypeRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSlotType(request))
  def deleteUtterances(request: DeleteUtterancesRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteUtterancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUtterances(request))
  def describeBotRecommendation(request: DescribeBotRecommendationRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeBotRecommendationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBotRecommendation(request))
  def updateIntent(request: UpdateIntentRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateIntentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIntent(request))
  def createBotAlias(request: CreateBotAliasRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBotAlias(request))
  def buildBotLocale(request: BuildBotLocaleRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.buildBotLocale(request))
  def listBuiltInIntents(request: ListBuiltInIntentsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBuiltInIntents(request))
  def updateBotRecommendation(request: UpdateBotRecommendationRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBotRecommendation(request))
  def batchDeleteCustomVocabularyItem(
      request: BatchDeleteCustomVocabularyItemRequest
  ): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteCustomVocabularyItem(request))
  def deleteBotAlias(request: DeleteBotAliasRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBotAlias(request))
  def deleteBotLocale(request: DeleteBotLocaleRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBotLocale(request))
  def updateResourcePolicy(request: UpdateResourcePolicyRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResourcePolicy(request))
  def deleteBotVersion(request: DeleteBotVersionRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBotVersion(request))
  def deleteExport(request: DeleteExportRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteExport(request))
  def listBotLocales(request: ListBotLocalesRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBotLocales(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createIntent(request: CreateIntentRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateIntentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIntent(request))
  def listBots(request: ListBotsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBots(request))
  def createSlotType(request: CreateSlotTypeRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateSlotTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSlotType(request))
  def describeImport(request: DescribeImportRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeImportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImport(request))
  def deleteResourcePolicy(request: DeleteResourcePolicyRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def createBot(request: CreateBotRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateBotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBot(request))
  def createSlot(request: CreateSlotRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateSlotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSlot(request))
  def describeBot(request: DescribeBotRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBot(request))
  def deleteIntent(
      request: DeleteIntentRequest
  ): ZIO[zio.aws.lexmodelsv2.LexModelsV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteIntent(request))
  def listRecommendedIntents(request: ListRecommendedIntentsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecommendedIntents(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listBotRecommendations(
      request: ListBotRecommendationsRequest
  ): ZIO[zio.aws.lexmodelsv2.LexModelsV2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listBotRecommendations(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeBotVersion(request: DescribeBotVersionRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBotVersion(request))
  def describeResourcePolicy(request: DescribeResourcePolicyRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResourcePolicy(request))
  def deleteImport(request: DeleteImportRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteImportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImport(request))
  def createExport(request: CreateExportRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createExport(request))
  def createResourcePolicy(request: CreateResourcePolicyRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.CreateResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResourcePolicy(request))
  def listSlotTypes(request: ListSlotTypesRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListSlotTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSlotTypes(request))
  def listBuiltInSlotTypes(request: ListBuiltInSlotTypesRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBuiltInSlotTypes(request))
  def listCustomVocabularyItems(request: ListCustomVocabularyItemsRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.ListCustomVocabularyItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomVocabularyItems(request))
  def deleteBot(request: DeleteBotRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteBotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBot(request))
  def deleteCustomVocabulary(request: DeleteCustomVocabularyRequest): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomVocabulary(request))
  def describeCustomVocabularyMetadata(
      request: DescribeCustomVocabularyMetadataRequest
  ): ZIO[
    zio.aws.lexmodelsv2.LexModelsV2,
    AwsError,
    zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomVocabularyMetadata(request))
}
