package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{ErrorMessage, ItemId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailedCustomVocabularyItem(
    itemId: Optional[ItemId] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    errorCode: Optional[zio.aws.lexmodelsv2.model.ErrorCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem = {
    import FailedCustomVocabularyItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem
      .builder()
      .optionallyWith(
        itemId.map(value => ItemId.unwrap(value): java.lang.String)
      )(_.itemId)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem.ReadOnly =
    zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem.wrap(buildAwsValue())
}
object FailedCustomVocabularyItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem =
      zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem(
        itemId.map(value => value),
        errorMessage.map(value => value),
        errorCode.map(value => value)
      )
    def itemId: Optional[ItemId]
    def errorMessage: Optional[ErrorMessage]
    def errorCode: Optional[zio.aws.lexmodelsv2.model.ErrorCode]
    def getItemId: ZIO[Any, AwsError, ItemId] =
      AwsError.unwrapOptionField("itemId", itemId)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem
  ) extends zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem.ReadOnly {
    override val itemId: Optional[ItemId] = zio.aws.core.internal
      .optionalFromNullable(impl.itemId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.ItemId(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.lexmodelsv2.model.primitives.ErrorMessage(value))
    override val errorCode: Optional[zio.aws.lexmodelsv2.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.lexmodelsv2.model.ErrorCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem
  ): zio.aws.lexmodelsv2.model.FailedCustomVocabularyItem.ReadOnly =
    new Wrapper(impl)
}
