package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeBotRequest(botId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest = {
    import DescribeBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeBotRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotRequest.wrap(buildAwsValue())
}
object DescribeBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotRequest =
      zio.aws.lexmodelsv2.model.DescribeBotRequest(botId)
    def botId: Id
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeBotRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest
  ): zio.aws.lexmodelsv2.model.DescribeBotRequest.ReadOnly = new Wrapper(impl)
}
