package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociatedTranscriptFilter(
    name: zio.aws.lexmodelsv2.model.AssociatedTranscriptFilterName,
    values: Iterable[FilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscriptFilter = {
    import AssociatedTranscriptFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscriptFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter.wrap(buildAwsValue())
}
object AssociatedTranscriptFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscriptFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter =
      zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter(name, values)
    def name: zio.aws.lexmodelsv2.model.AssociatedTranscriptFilterName
    def values: List[FilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AssociatedTranscriptFilterName
    ] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscriptFilter
  ) extends zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter.ReadOnly {
    override val name
        : zio.aws.lexmodelsv2.model.AssociatedTranscriptFilterName =
      zio.aws.lexmodelsv2.model.AssociatedTranscriptFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscriptFilter
  ): zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter.ReadOnly =
    new Wrapper(impl)
}
