package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{SampleUtterancesCount, Name, Id}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RecommendedIntentSummary(
    intentId: Optional[Id] = Optional.Absent,
    intentName: Optional[Name] = Optional.Absent,
    sampleUtterancesCount: Optional[SampleUtterancesCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.RecommendedIntentSummary = {
    import RecommendedIntentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.RecommendedIntentSummary
      .builder()
      .optionallyWith(
        intentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.intentId)
      .optionallyWith(
        intentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        sampleUtterancesCount.map(value =>
          SampleUtterancesCount.unwrap(value): Integer
        )
      )(_.sampleUtterancesCount)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.RecommendedIntentSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.RecommendedIntentSummary.wrap(buildAwsValue())
}
object RecommendedIntentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.RecommendedIntentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.RecommendedIntentSummary =
      zio.aws.lexmodelsv2.model.RecommendedIntentSummary(
        intentId.map(value => value),
        intentName.map(value => value),
        sampleUtterancesCount.map(value => value)
      )
    def intentId: Optional[Id]
    def intentName: Optional[Name]
    def sampleUtterancesCount: Optional[SampleUtterancesCount]
    def getIntentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("intentId", intentId)
    def getIntentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getSampleUtterancesCount: ZIO[Any, AwsError, SampleUtterancesCount] =
      AwsError.unwrapOptionField("sampleUtterancesCount", sampleUtterancesCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.RecommendedIntentSummary
  ) extends zio.aws.lexmodelsv2.model.RecommendedIntentSummary.ReadOnly {
    override val intentId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.intentId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val intentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val sampleUtterancesCount: Optional[SampleUtterancesCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleUtterancesCount())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.SampleUtterancesCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.RecommendedIntentSummary
  ): zio.aws.lexmodelsv2.model.RecommendedIntentSummary.ReadOnly = new Wrapper(
    impl
  )
}
