package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  IntentSignature,
  Timestamp,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class IntentSummary(
    intentId: Optional[Id] = Optional.Absent,
    intentName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    parentIntentSignature: Optional[IntentSignature] = Optional.Absent,
    inputContexts: Optional[Iterable[zio.aws.lexmodelsv2.model.InputContext]] =
      Optional.Absent,
    outputContexts: Optional[
      Iterable[zio.aws.lexmodelsv2.model.OutputContext]
    ] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary = {
    import IntentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary
      .builder()
      .optionallyWith(
        intentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.intentId)
      .optionallyWith(
        intentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parentIntentSignature.map(value =>
          IntentSignature.unwrap(value): java.lang.String
        )
      )(_.parentIntentSignature)
      .optionallyWith(
        inputContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputContexts)
      .optionallyWith(
        outputContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputContexts)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentSummary.wrap(buildAwsValue())
}
object IntentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentSummary =
      zio.aws.lexmodelsv2.model.IntentSummary(
        intentId.map(value => value),
        intentName.map(value => value),
        description.map(value => value),
        parentIntentSignature.map(value => value),
        inputContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdatedDateTime.map(value => value)
      )
    def intentId: Optional[Id]
    def intentName: Optional[Name]
    def description: Optional[Description]
    def parentIntentSignature: Optional[IntentSignature]
    def inputContexts
        : Optional[List[zio.aws.lexmodelsv2.model.InputContext.ReadOnly]]
    def outputContexts
        : Optional[List[zio.aws.lexmodelsv2.model.OutputContext.ReadOnly]]
    def lastUpdatedDateTime: Optional[Timestamp]
    def getIntentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("intentId", intentId)
    def getIntentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParentIntentSignature: ZIO[Any, AwsError, IntentSignature] =
      AwsError.unwrapOptionField("parentIntentSignature", parentIntentSignature)
    def getInputContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.InputContext.ReadOnly
    ]] = AwsError.unwrapOptionField("inputContexts", inputContexts)
    def getOutputContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.OutputContext.ReadOnly
    ]] = AwsError.unwrapOptionField("outputContexts", outputContexts)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary
  ) extends zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly {
    override val intentId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.intentId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val intentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val parentIntentSignature: Optional[IntentSignature] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentIntentSignature())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.IntentSignature(value)
        )
    override val inputContexts
        : Optional[List[zio.aws.lexmodelsv2.model.InputContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.InputContext.wrap(item)
          }.toList
        )
    override val outputContexts
        : Optional[List[zio.aws.lexmodelsv2.model.OutputContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.OutputContext.wrap(item)
          }.toList
        )
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary
  ): zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly = new Wrapper(impl)
}
