package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSlotRequest(
    slotId: Id,
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    intentId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest = {
    import DeleteSlotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest
      .builder()
      .slotId(Id.unwrap(slotId): java.lang.String)
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .intentId(Id.unwrap(intentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteSlotRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteSlotRequest.wrap(buildAwsValue())
}
object DeleteSlotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteSlotRequest =
      zio.aws.lexmodelsv2.model.DeleteSlotRequest(
        slotId,
        botId,
        botVersion,
        localeId,
        intentId
      )
    def slotId: Id
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def intentId: Id
    def getSlotId: ZIO[Any, Nothing, Id] = ZIO.succeed(slotId)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getIntentId: ZIO[Any, Nothing, Id] = ZIO.succeed(intentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteSlotRequest.ReadOnly {
    override val slotId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.slotId())
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val intentId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.intentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest
  ): zio.aws.lexmodelsv2.model.DeleteSlotRequest.ReadOnly = new Wrapper(impl)
}
