package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, BotVersion}
import scala.jdk.CollectionConverters.*
final case class BotAliasHistoryEvent(
    botVersion: Optional[BotVersion] = Optional.Absent,
    startDate: Optional[Timestamp] = Optional.Absent,
    endDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent = {
    import BotAliasHistoryEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent
      .builder()
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(startDate.map(value => Timestamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => Timestamp.unwrap(value): Instant))(
        _.endDate
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly =
    zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.wrap(buildAwsValue())
}
object BotAliasHistoryEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotAliasHistoryEvent =
      zio.aws.lexmodelsv2.model.BotAliasHistoryEvent(
        botVersion.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value)
      )
    def botVersion: Optional[BotVersion]
    def startDate: Optional[Timestamp]
    def endDate: Optional[Timestamp]
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDate", endDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent
  ) extends zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly {
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val startDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val endDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent
  ): zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly = new Wrapper(impl)
}
