package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait SlotTypeCategory {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory
}
object SlotTypeCategory {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory
  ): zio.aws.lexmodelsv2.model.SlotTypeCategory = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory.CUSTOM =>
      val r = Custom
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory.EXTENDED =>
      val r = Extended
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory.EXTERNAL_GRAMMAR =>
      val r = ExternalGrammar
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.SlotTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object Custom extends zio.aws.lexmodelsv2.model.SlotTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory.CUSTOM
  }
  case object Extended extends zio.aws.lexmodelsv2.model.SlotTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory.EXTENDED
  }
  case object ExternalGrammar
      extends zio.aws.lexmodelsv2.model.SlotTypeCategory {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory.EXTERNAL_GRAMMAR
  }
}
